/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.Map;
import org.inspektr.common.ioc.annotation.NotEmpty;
import org.jasig.cas.authentication.AbstractAuthenticationManager;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DirectMappingAuthenticationManagerImpl
extends AbstractAuthenticationManager {
    @NotEmpty
    private Map<Class<? extends Credentials>, DirectAuthenticationHandlerMappingHolder> credentialsMapping;

    @Override
    protected AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal> authenticateAndObtainPrincipal(Credentials credentials) throws AuthenticationException {
        Class<?> credentialsClass = credentials.getClass();
        DirectAuthenticationHandlerMappingHolder d = this.credentialsMapping.get(credentialsClass);
        Assert.notNull((Object)d, (String)("no mapping found for: " + credentialsClass.getName()));
        if (!d.getAuthenticationHandler().authenticate(credentials)) {
            throw new BadCredentialsAuthenticationException();
        }
        Principal p = d.getCredentialsToPrincipalResolver().resolvePrincipal(credentials);
        return new AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal>(d.getAuthenticationHandler(), p);
    }

    public final void setCredentialsMapping(Map<Class<? extends Credentials>, DirectAuthenticationHandlerMappingHolder> credentialsMapping) {
        this.credentialsMapping = credentialsMapping;
    }

    public static final class DirectAuthenticationHandlerMappingHolder {
        private AuthenticationHandler authenticationHandler;
        private CredentialsToPrincipalResolver credentialsToPrincipalResolver;

        public final AuthenticationHandler getAuthenticationHandler() {
            return this.authenticationHandler;
        }

        public void setAuthenticationHandler(AuthenticationHandler authenticationHandler) {
            this.authenticationHandler = authenticationHandler;
        }

        public CredentialsToPrincipalResolver getCredentialsToPrincipalResolver() {
            return this.credentialsToPrincipalResolver;
        }

        public void setCredentialsToPrincipalResolver(CredentialsToPrincipalResolver credentialsToPrincipalResolver) {
            this.credentialsToPrincipalResolver = credentialsToPrincipalResolver;
        }
    }
}

