/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.Map;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.authentication.AbstractAuthenticationManager;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.handler.UnsupportedCredentialsException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedAuthenticationHandlerAndCredentialsToPrincipalResolverAuthenticationManager
extends AbstractAuthenticationManager {
    @NotNull
    private final Map<AuthenticationHandler, CredentialsToPrincipalResolver> linkedHandlers;

    public LinkedAuthenticationHandlerAndCredentialsToPrincipalResolverAuthenticationManager(Map<AuthenticationHandler, CredentialsToPrincipalResolver> linkedHandlers) {
        this.linkedHandlers = linkedHandlers;
    }

    @Override
    protected AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal> authenticateAndObtainPrincipal(Credentials credentials) throws AuthenticationException {
        boolean foundOneThatWorks = false;
        for (AuthenticationHandler authenticationHandler : this.linkedHandlers.keySet()) {
            if (!authenticationHandler.supports(credentials)) continue;
            foundOneThatWorks = true;
            if (!authenticationHandler.authenticate(credentials)) continue;
            Principal p = this.linkedHandlers.get(authenticationHandler).resolvePrincipal(credentials);
            return new AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal>(authenticationHandler, p);
        }
        if (foundOneThatWorks) {
            throw BadCredentialsAuthenticationException.ERROR;
        }
        throw UnsupportedCredentialsException.ERROR;
    }
}

