/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.authentication.principal.AbstractWebApplicationService;
import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.util.SamlUtils;
import org.jdom.Document;
import org.springframework.util.StringUtils;
import org.springframework.webflow.util.Base64;

public class GoogleAccountsService
extends AbstractWebApplicationService {
    private static final long serialVersionUID = 6678711809842282833L;
    private static Random random = new Random();
    private static final char[] charMapping = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
    private static final String CONST_PARAM_SERVICE = "SAMLRequest";
    private static final String CONST_RELAY_STATE = "RelayState";
    private static final String TEMPLATE_SAML_RESPONSE = "<samlp:Response ID=\"<RESPONSE_ID>\" IssueInstant=\"<ISSUE_INSTANT>\" Version=\"2.0\" xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><samlp:Status><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\" /></samlp:Status><Assertion ID=\"<ASSERTION_ID>\" IssueInstant=\"2003-04-17T00:46:02Z\" Version=\"2.0\" xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\"><Issuer>https://www.opensaml.org/IDP</Issuer><Subject><NameID Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:emailAddress\"><USERNAME_STRING></NameID><SubjectConfirmation Method=\"urn:oasis:names:tc:SAML:2.0:cm:bearer\"><SubjectConfirmationData Recipient=\"<ACS_URL>\" NotOnOrAfter=\"<NOT_ON_OR_AFTER>\" InResponseTo=\"<REQUEST_ID>\" /></SubjectConfirmation></Subject><Conditions NotBefore=\"2003-04-17T00:46:02Z\" NotOnOrAfter=\"<NOT_ON_OR_AFTER>\"><AudienceRestriction><Audience><ACS_URL></Audience></AudienceRestriction></Conditions><AuthnStatement AuthnInstant=\"<AUTHN_INSTANT>\"><AuthnContext><AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:Password</AuthnContextClassRef></AuthnContext></AuthnStatement></Assertion></samlp:Response>";
    private final String relayState;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private final String requestId;
    private final String alternateUserName;

    protected GoogleAccountsService(String id, String relayState, String requestId, PrivateKey privateKey, PublicKey publicKey, String alternateUserName) {
        this(id, id, null, relayState, requestId, privateKey, publicKey, alternateUserName);
    }

    protected GoogleAccountsService(String id, String originalUrl, String artifactId, String relayState, String requestId, PrivateKey privateKey, PublicKey publicKey, String alternateUserName) {
        super(id, originalUrl, artifactId, null);
        this.relayState = relayState;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.requestId = requestId;
        this.alternateUserName = alternateUserName;
    }

    public static GoogleAccountsService createServiceFrom(HttpServletRequest request, PrivateKey privateKey, PublicKey publicKey, String alternateUserName) {
        String relayState = request.getParameter(CONST_RELAY_STATE);
        String xmlRequest = GoogleAccountsService.decodeAuthnRequestXML(request.getParameter(CONST_PARAM_SERVICE));
        if (!StringUtils.hasText((String)xmlRequest)) {
            return null;
        }
        Document document = SamlUtils.constructDocumentFromXmlString(xmlRequest);
        if (document == null) {
            return null;
        }
        String assertionConsumerServiceUrl = document.getRootElement().getAttributeValue("AssertionConsumerServiceURL");
        String requestId = document.getRootElement().getAttributeValue("ID");
        return new GoogleAccountsService(assertionConsumerServiceUrl, relayState, requestId, privateKey, publicKey, alternateUserName);
    }

    public Response getResponse(String ticketId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String samlResponse = this.constructSamlResponse();
        String signedResponse = SamlUtils.signSamlResponse(samlResponse, this.privateKey, this.publicKey);
        parameters.put("SAMLResponse", signedResponse);
        parameters.put(CONST_RELAY_STATE, this.relayState);
        return Response.getPostResponse(this.getOriginalUrl(), parameters);
    }

    public boolean logOutOfService(String sessionIdentifier) {
        return false;
    }

    private String constructSamlResponse() {
        String attributeValue;
        String samlResponse = TEMPLATE_SAML_RESPONSE;
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(1, 1);
        String userId = this.alternateUserName == null ? this.getPrincipal().getId() : ((attributeValue = (String)this.getPrincipal().getAttributes().get(this.alternateUserName)) == null ? this.getPrincipal().getId() : attributeValue);
        samlResponse = samlResponse.replace("<USERNAME_STRING>", userId);
        samlResponse = samlResponse.replace("<RESPONSE_ID>", GoogleAccountsService.createID());
        samlResponse = samlResponse.replace("<ISSUE_INSTANT>", SamlUtils.getCurrentDateAndTime());
        samlResponse = samlResponse.replace("<AUTHN_INSTANT>", SamlUtils.getCurrentDateAndTime());
        samlResponse = samlResponse.replaceAll("<NOT_ON_OR_AFTER>", SamlUtils.getFormattedDateAndTime(c.getTime()));
        samlResponse = samlResponse.replace("<ASSERTION_ID>", GoogleAccountsService.createID());
        samlResponse = samlResponse.replaceAll("<ACS_URL>", this.getId());
        samlResponse = samlResponse.replace("<REQUEST_ID>", this.requestId);
        return samlResponse;
    }

    private static String createID() {
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        char[] chars = new char[40];
        for (int i = 0; i < bytes.length; ++i) {
            int left = bytes[i] >> 4 & 0xF;
            int right = bytes[i] & 0xF;
            chars[i * 2] = charMapping[left];
            chars[i * 2 + 1] = charMapping[right];
        }
        return String.valueOf(chars);
    }

    private static String decodeAuthnRequestXML(String encodedRequestXmlString) {
        if (encodedRequestXmlString == null) {
            return null;
        }
        byte[] decodedBytes = GoogleAccountsService.base64Decode(encodedRequestXmlString);
        if (decodedBytes == null) {
            return null;
        }
        String inflated = GoogleAccountsService.inflate(decodedBytes);
        if (inflated != null) {
            return inflated;
        }
        return GoogleAccountsService.zlibDeflate(decodedBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String zlibDeflate(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InflaterInputStream iis = new InflaterInputStream(bais);
        byte[] buf = new byte[1024];
        try {
            int count = iis.read(buf);
            while (count != -1) {
                baos.write(buf, 0, count);
                count = iis.read(buf);
            }
            String string = new String(baos.toByteArray());
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                iis.close();
            }
            catch (Exception e) {}
        }
    }

    private static byte[] base64Decode(String xml) {
        try {
            Base64 base64Decoder = new Base64();
            byte[] xmlBytes = xml.getBytes("UTF-8");
            return base64Decoder.decode(xmlBytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String inflate(byte[] bytes) {
        Inflater inflater = new Inflater(true);
        byte[] xmlMessageBytes = new byte[10000];
        byte[] extendedBytes = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, extendedBytes, 0, bytes.length);
        extendedBytes[bytes.length] = 0;
        inflater.setInput(extendedBytes);
        try {
            int resultLength = inflater.inflate(xmlMessageBytes);
            inflater.end();
            if (!inflater.finished()) {
                throw new RuntimeException("buffer not large enough.");
            }
            inflater.end();
            return new String(xmlMessageBytes, 0, resultLength, "UTF-8");
        }
        catch (DataFormatException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot find encoding: UTF-8", e);
        }
    }
}

