/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;

public abstract class AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter
extends AbstractThrottledSubmissionHandlerInterceptorAdapter {
    private final ConcurrentMap<String, AtomicInteger> ipMap = new ConcurrentHashMap<String, AtomicInteger>();

    protected final int findCount(HttpServletRequest request, String usernameParameter, int failureRangeInSeconds) {
        AtomicInteger existingValue = (AtomicInteger)this.ipMap.get(this.constructKey(request, usernameParameter));
        return existingValue == null ? 0 : existingValue.get();
    }

    protected final void updateCount(HttpServletRequest request, String usernameParameter) {
        AtomicInteger newAtomicInteger = new AtomicInteger(1);
        AtomicInteger oldAtomicInteger = this.ipMap.putIfAbsent(this.constructKey(request, usernameParameter), newAtomicInteger);
        if (oldAtomicInteger != null) {
            oldAtomicInteger.incrementAndGet();
        }
    }

    protected abstract String constructKey(HttpServletRequest var1, String var2);

    public final void decrementCounts() {
        Set keys = this.ipMap.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            AtomicInteger integer = (AtomicInteger)this.ipMap.get(key);
            int newValue = integer.decrementAndGet();
            if (newValue != 0) continue;
            iter.remove();
        }
    }
}

