/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.web.view.AbstractCasView;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAudienceRestrictionCondition;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;

public class Saml10SuccessResponseView
extends AbstractCasView {
    private static final String NAMESPACE = "http://www.ja-sig.org/products/cas/";
    private static final String DEFAULT_ENCODING = "UTF-8";
    @NotNull
    private String issuer;
    private long issueLength = 30000L;
    @NotNull
    private String encoding = "UTF-8";

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Assertion assertion = this.getAssertionFrom(model);
            Authentication authentication = assertion.getChainedAuthentications().get(0);
            Date currentDate = new Date();
            String authenticationMethod = (String)authentication.getAttributes().get("samlAuthenticationStatementAuthMethod");
            Service service = assertion.getService();
            SAMLResponse samlResponse = new SAMLResponse(null, service.getId(), new ArrayList(), null);
            samlResponse.setIssueInstant(currentDate);
            SAMLAssertion samlAssertion = new SAMLAssertion();
            samlAssertion.setIssueInstant(currentDate);
            samlAssertion.setIssuer(this.issuer);
            samlAssertion.setNotBefore(currentDate);
            samlAssertion.setNotOnOrAfter(new Date(currentDate.getTime() + this.issueLength));
            SAMLAudienceRestrictionCondition samlAudienceRestrictionCondition = new SAMLAudienceRestrictionCondition();
            samlAudienceRestrictionCondition.addAudience(service.getId());
            SAMLAuthenticationStatement samlAuthenticationStatement = new SAMLAuthenticationStatement();
            samlAuthenticationStatement.setAuthInstant(authentication.getAuthenticatedDate());
            samlAuthenticationStatement.setAuthMethod(authenticationMethod != null ? authenticationMethod : "urn:oasis:names:tc:SAML:1.0:am:unspecified");
            samlAuthenticationStatement.setSubject(this.getSamlSubject(authentication));
            if (!authentication.getPrincipal().getAttributes().isEmpty()) {
                SAMLAttributeStatement attributeStatement = new SAMLAttributeStatement();
                attributeStatement.setSubject(this.getSamlSubject(authentication));
                samlAssertion.addStatement((SAMLStatement)attributeStatement);
                for (String key : authentication.getPrincipal().getAttributes().keySet()) {
                    Object value = authentication.getPrincipal().getAttributes().get(key);
                    SAMLAttribute attribute = new SAMLAttribute();
                    attribute.setName(key);
                    attribute.setNamespace(NAMESPACE);
                    if (value instanceof Collection) {
                        attribute.setValues((Collection)value);
                    } else {
                        ArrayList<Object> c = new ArrayList<Object>();
                        c.add(value);
                        attribute.setValues(c);
                    }
                    attributeStatement.addAttribute(attribute);
                }
            }
            samlAssertion.addStatement((SAMLStatement)samlAuthenticationStatement);
            samlAssertion.addCondition((SAMLCondition)samlAudienceRestrictionCondition);
            samlResponse.addAssertion(samlAssertion);
            String xmlResponse = samlResponse.toString();
            response.setContentType("text/xml; charset=" + this.encoding);
            response.getWriter().print("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            response.getWriter().print("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body>");
            response.getWriter().print(xmlResponse);
            response.getWriter().print("</SOAP-ENV:Body></SOAP-ENV:Envelope>");
            response.flushBuffer();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected SAMLSubject getSamlSubject(Authentication authentication) throws SAMLException {
        SAMLSubject samlSubject = new SAMLSubject();
        samlSubject.addConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:artifact");
        SAMLNameIdentifier samlNameIdentifier = new SAMLNameIdentifier();
        samlNameIdentifier.setName(authentication.getPrincipal().getId());
        samlSubject.setNameIdentifier(samlNameIdentifier);
        return samlSubject;
    }

    public void setIssueLength(long issueLength) {
        this.issueLength = issueLength;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

