/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.slf4j.Logger;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JpaTicketRegistry
extends AbstractDistributedTicketRegistry {
    @NotNull
    private JpaTemplate jpaTemplate;
    @NotNull
    private String ticketGrantingTicketPrefix = "TGT";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public JpaTicketRegistry(EntityManagerFactory factory) {
        this.jpaTemplate = new JpaTemplate(factory);
    }

    @Override
    protected void updateTicket(Ticket ticket) {
        this.jpaTemplate.merge((Object)ticket);
    }

    @Override
    public void addTicket(Ticket ticket) {
        Ticket ticket2 = ticket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ticket2);
        JpaTicketRegistry.addTicket_aroundBody1$advice(this, ticket2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    @Transactional(readOnly=false)
    public boolean deleteTicket(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        return Conversions.booleanValue((Object)JpaTicketRegistry.deleteTicket_aroundBody3$advice(this, string, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    private void deleteTicketAndChildren(Ticket ticket) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", ticket.getId());
        List ticketGrantingTicketImpls = this.jpaTemplate.findByNamedParams("select t from TicketGrantingTicketImpl t where t.ticketGrantingTicket.id = :id", params);
        List serviceTicketImpls = this.jpaTemplate.findByNamedParams("select s from ServiceTicketImpl s where s.ticketGrantingTicket.id = :id", params);
        for (ServiceTicketImpl s : serviceTicketImpls) {
            this.removeTicket(s);
        }
        for (TicketGrantingTicketImpl t : ticketGrantingTicketImpls) {
            this.deleteTicketAndChildren(t);
        }
        this.removeTicket(ticket);
    }

    private void removeTicket(Ticket ticket) {
        try {
            if (this.log.isDebugEnabled()) {
                Date creationDate = new Date(ticket.getCreationTime());
                this.log.debug("Removing Ticket >" + ticket.getId() + "< created: " + creationDate.toString());
            }
            this.jpaTemplate.remove((Object)ticket);
        }
        catch (Exception e) {
            this.log.error("Error removing " + ticket + " from registry.", (Throwable)e);
        }
    }

    @Override
    public Ticket getTicket(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        return (Ticket)JpaTicketRegistry.getTicket_aroundBody5$advice(this, string, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private Ticket getRawTicket(String ticketId) {
        try {
            if (ticketId.startsWith(this.ticketGrantingTicketPrefix)) {
                return (Ticket)this.jpaTemplate.find(TicketGrantingTicketImpl.class, (Object)ticketId);
            }
            return (Ticket)this.jpaTemplate.find(ServiceTicketImpl.class, (Object)ticketId);
        }
        catch (Exception e) {
            this.log.error("Error getting ticket " + ticketId + " from registry.", (Throwable)e);
            return null;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<Ticket> getTickets() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        return (Collection)JpaTicketRegistry.getTickets_aroundBody7$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void setTicketGrantingTicketPrefix(String ticketGrantingTicketPrefix) {
        this.ticketGrantingTicketPrefix = ticketGrantingTicketPrefix;
    }

    static {
        Factory factory = new Factory("JpaTicketRegistry.java", Class.forName("org.jasig.cas.ticket.registry.JpaTicketRegistry"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTicket", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "org.jasig.cas.ticket.Ticket:", "ticket:", "", "void"), 48);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTicket", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "java.lang.String:", "ticketId:", "", "boolean"), 53);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTicket", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "java.lang.String:", "ticketId:", "", "org.jasig.cas.ticket.Ticket"), 98);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTickets", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "", "", "", "java.util.Collection"), 116);
    }

    private static final /* synthetic */ Object addTicket_aroundBody1$advice(JpaTicketRegistry ajc$this, Ticket ticket, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            ajc$this.jpaTemplate.persist((Object)ticket);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ boolean deleteTicket_aroundBody2(JpaTicketRegistry ajc$this, String ticketId, JoinPoint joinPoint) {
        Ticket ticket = ajc$this.getRawTicket(ticketId);
        if (ticket == null) {
            return false;
        }
        if (ticket instanceof ServiceTicket) {
            ajc$this.removeTicket(ticket);
            return true;
        }
        ajc$this.deleteTicketAndChildren(ticket);
        return true;
    }

    private static final /* synthetic */ Object deleteTicket_aroundBody3$advice(JpaTicketRegistry ajc$this, String ticketId, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)JpaTicketRegistry.deleteTicket_aroundBody2(ajc$this, ticketId, (JoinPoint)proceedingJoinPoint2));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ Object getTicket_aroundBody5$advice(JpaTicketRegistry ajc$this, String ticketId, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Ticket ticket;
        Ticket returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            ticket = returnVal = ajc$this.getProxiedTicketInstance(ajc$this.getRawTicket(ticketId));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return ticket;
    }

    private static final /* synthetic */ Collection getTickets_aroundBody6(JpaTicketRegistry ajc$this, JoinPoint joinPoint) {
        List tgts = ajc$this.jpaTemplate.find("select t from TicketGrantingTicketImpl t");
        List sts = ajc$this.jpaTemplate.find("select s from ServiceTicketImpl s");
        ArrayList tickets = new ArrayList();
        tickets.addAll(tgts);
        tickets.addAll(sts);
        return tickets;
    }

    private static final /* synthetic */ Object getTickets_aroundBody7$advice(JpaTicketRegistry ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Collection collection;
        Collection returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            collection = returnVal = JpaTicketRegistry.getTickets_aroundBody6(ajc$this, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return collection;
    }
}

