/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jasig.cas.authentication.AbstractAuthenticationManager;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.handler.UnsupportedCredentialsException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthenticationManagerImpl
extends AbstractAuthenticationManager {
    @NotNull
    @Size(min=1)
    private List<AuthenticationHandler> authenticationHandlers;
    @NotNull
    @Size(min=1)
    private List<CredentialsToPrincipalResolver> credentialsToPrincipalResolvers;

    @Override
    protected AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal> authenticateAndObtainPrincipal(Credentials credentials) throws AuthenticationException {
        boolean foundSupported = false;
        boolean authenticated = false;
        AuthenticationHandler authenticatedClass = null;
        AuthenticationException unAuthSupportedHandlerException = BadCredentialsAuthenticationException.ERROR;
        for (AuthenticationHandler authenticationHandler : this.authenticationHandlers) {
            if (!authenticationHandler.supports(credentials)) continue;
            foundSupported = true;
            String handlerName = authenticationHandler.getClass().getName();
            try {
                if (!authenticationHandler.authenticate(credentials)) {
                    this.log.info("{} failed to authenticate {}", (Object)handlerName, (Object)credentials);
                    continue;
                }
                this.log.info("{} successfully authenticated {}", (Object)handlerName, (Object)credentials);
                authenticatedClass = authenticationHandler;
                authenticated = true;
                break;
            }
            catch (AuthenticationException e) {
                unAuthSupportedHandlerException = e;
                this.logAuthenticationHandlerError(handlerName, credentials, e);
            }
            catch (Exception e) {
                this.logAuthenticationHandlerError(handlerName, credentials, e);
            }
        }
        if (!authenticated) {
            if (foundSupported) {
                throw unAuthSupportedHandlerException;
            }
            throw UnsupportedCredentialsException.ERROR;
        }
        foundSupported = false;
        for (CredentialsToPrincipalResolver credentialsToPrincipalResolver : this.credentialsToPrincipalResolvers) {
            if (!credentialsToPrincipalResolver.supports(credentials)) continue;
            Principal principal = credentialsToPrincipalResolver.resolvePrincipal(credentials);
            this.log.info("Resolved principal " + principal);
            foundSupported = true;
            if (principal == null) continue;
            return new AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal>(authenticatedClass, principal);
        }
        if (foundSupported) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("CredentialsToPrincipalResolver found but no principal returned.");
            }
            throw BadCredentialsAuthenticationException.ERROR;
        }
        this.log.error("CredentialsToPrincipalResolver not found for " + credentials.getClass().getName());
        throw UnsupportedCredentialsException.ERROR;
    }

    public void setAuthenticationHandlers(List<AuthenticationHandler> authenticationHandlers) {
        this.authenticationHandlers = authenticationHandlers;
    }

    public void setCredentialsToPrincipalResolvers(List<CredentialsToPrincipalResolver> credentialsToPrincipalResolvers) {
        this.credentialsToPrincipalResolvers = credentialsToPrincipalResolvers;
    }
}

