/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.util.Arrays;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.monitor.Monitor;
import org.jasig.cas.monitor.SessionStatus;
import org.jasig.cas.monitor.StatusCode;
import org.jasig.cas.monitor.TicketRegistryState;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionMonitor
implements Monitor<SessionStatus> {
    @NotNull
    private TicketRegistryState registryState;
    private int sessionCountWarnThreshold = -1;
    private int serviceTicketCountWarnThreshold = -1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public void setTicketRegistry(TicketRegistryState state) {
        this.registryState = state;
    }

    public void setSessionCountWarnThreshold(int threshold) {
        this.sessionCountWarnThreshold = threshold;
    }

    public void setServiceTicketCountWarnThreshold(int threshold) {
        this.serviceTicketCountWarnThreshold = threshold;
    }

    @Override
    public String getName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        return (String)SessionMonitor.getName_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public SessionStatus observe() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        return (SessionStatus)SessionMonitor.observe_aroundBody3$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    static {
        SessionMonitor.ajc$preClinit();
    }

    private static final /* synthetic */ String getName_aroundBody0(SessionMonitor ajc$this, JoinPoint joinPoint) {
        return SessionMonitor.class.getSimpleName();
    }

    private static final /* synthetic */ Object getName_aroundBody1$advice(SessionMonitor ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = SessionMonitor.getName_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    private static final /* synthetic */ SessionStatus observe_aroundBody2(SessionMonitor ajc$this, JoinPoint joinPoint) {
        try {
            int sessionCount = ajc$this.registryState.sessionCount();
            int ticketCount = ajc$this.registryState.serviceTicketCount();
            StringBuilder msg = new StringBuilder();
            StatusCode code = StatusCode.OK;
            if (ajc$this.sessionCountWarnThreshold > -1 && sessionCount > ajc$this.sessionCountWarnThreshold) {
                code = StatusCode.WARN;
                msg.append(String.format("Session count (%s) is above threshold %s. ", sessionCount, ajc$this.sessionCountWarnThreshold));
            } else {
                msg.append(sessionCount).append(" sessions. ");
            }
            if (ajc$this.serviceTicketCountWarnThreshold > -1 && ticketCount > ajc$this.serviceTicketCountWarnThreshold) {
                code = StatusCode.WARN;
                msg.append(String.format("Service ticket count (%s) is above threshold %s.", ticketCount, ajc$this.serviceTicketCountWarnThreshold));
            } else {
                msg.append(ticketCount).append(" service tickets.");
            }
            return new SessionStatus(code, msg.toString(), sessionCount, ticketCount);
        }
        catch (Exception e) {
            return new SessionStatus(StatusCode.ERROR, e.getMessage());
        }
    }

    private static final /* synthetic */ Object observe_aroundBody3$advice(SessionMonitor ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        SessionStatus sessionStatus;
        SessionStatus returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            sessionStatus = returnVal = SessionMonitor.observe_aroundBody2(ajc$this, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return sessionStatus;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SessionMonitor.java", SessionMonitor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getName", "org.jasig.cas.monitor.SessionMonitor", "", "", "", "java.lang.String"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "observe", "org.jasig.cas.monitor.SessionMonitor", "", "", "", "org.jasig.cas.monitor.SessionStatus"), 79);
    }
}

