/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import com.github.inspektr.audit.annotation.Audit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.ServiceRegistryDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultServicesManagerImpl
implements ReloadableServicesManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private ServiceRegistryDao serviceRegistryDao;
    private ConcurrentHashMap<Long, RegisteredService> services = new ConcurrentHashMap();
    private RegisteredService disabledRegisteredService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public DefaultServicesManagerImpl(ServiceRegistryDao serviceRegistryDao) {
        this(serviceRegistryDao, new ArrayList<String>());
    }

    public DefaultServicesManagerImpl(ServiceRegistryDao serviceRegistryDao, List<String> defaultAttributes) {
        this.serviceRegistryDao = serviceRegistryDao;
        this.disabledRegisteredService = this.constructDefaultRegisteredService(defaultAttributes);
        this.load();
    }

    @Override
    @Transactional(readOnly=false)
    @Audit(action="DELETE_SERVICE", actionResolverName="DELETE_SERVICE_ACTION_RESOLVER", resourceResolverName="DELETE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService delete(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        return (RegisteredService)DefaultServicesManagerImpl.delete_aroundBody1$advice(this, l, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public RegisteredService findServiceBy(Service service) {
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)service2);
        return (RegisteredService)DefaultServicesManagerImpl.findServiceBy_aroundBody3$advice(this, service2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public RegisteredService findServiceBy(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        return (RegisteredService)DefaultServicesManagerImpl.findServiceBy_aroundBody5$advice(this, l, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    protected TreeSet<RegisteredService> convertToTreeSet() {
        return new TreeSet<RegisteredService>(this.services.values());
    }

    @Override
    public Collection<RegisteredService> getAllServices() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        return (Collection)DefaultServicesManagerImpl.getAllServices_aroundBody7$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public boolean matchesExistingService(Service service) {
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)service2);
        return Conversions.booleanValue((Object)DefaultServicesManagerImpl.matchesExistingService_aroundBody9$advice(this, service2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @Override
    @Transactional(readOnly=false)
    @Audit(action="SAVE_SERVICE", actionResolverName="SAVE_SERVICE_ACTION_RESOLVER", resourceResolverName="SAVE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService save(RegisteredService registeredService) {
        RegisteredService registeredService2 = registeredService;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)registeredService2);
        return (RegisteredService)DefaultServicesManagerImpl.save_aroundBody11$advice(this, registeredService2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public void reload() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        DefaultServicesManagerImpl.reload_aroundBody13$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private void load() {
        ConcurrentHashMap<Long, RegisteredService> localServices = new ConcurrentHashMap<Long, RegisteredService>();
        for (RegisteredService r : this.serviceRegistryDao.load()) {
            this.log.debug("Adding registered service " + r.getServiceId());
            localServices.put(r.getId(), r);
        }
        this.services = localServices;
        this.log.info(String.format("Loaded %s services.", this.services.size()));
    }

    private RegisteredService constructDefaultRegisteredService(List<String> attributes) {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setAllowedToProxy(true);
        r.setAnonymousAccess(false);
        r.setEnabled(true);
        r.setSsoEnabled(true);
        r.setAllowedAttributes(attributes);
        if (attributes == null || attributes.isEmpty()) {
            r.setIgnoreAttributes(true);
        }
        return r;
    }

    static {
        DefaultServicesManagerImpl.ajc$preClinit();
    }

    private static final /* synthetic */ RegisteredService delete_aroundBody0(DefaultServicesManagerImpl ajc$this, long id, JoinPoint joinPoint) {
        RegisteredService r = ajc$this.findServiceBy(id);
        if (r == null) {
            return null;
        }
        ajc$this.serviceRegistryDao.delete(r);
        ajc$this.services.remove(id);
        return r;
    }

    private static final /* synthetic */ Object delete_aroundBody1$advice(DefaultServicesManagerImpl ajc$this, long id, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        RegisteredService registeredService;
        RegisteredService returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            registeredService = returnVal = DefaultServicesManagerImpl.delete_aroundBody0(ajc$this, id, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return registeredService;
    }

    private static final /* synthetic */ RegisteredService findServiceBy_aroundBody2(DefaultServicesManagerImpl ajc$this, Service service, JoinPoint joinPoint) {
        TreeSet<RegisteredService> c = ajc$this.convertToTreeSet();
        if (c.isEmpty()) {
            return ajc$this.disabledRegisteredService;
        }
        for (RegisteredService r : c) {
            if (!r.matches(service)) continue;
            return r;
        }
        return null;
    }

    private static final /* synthetic */ Object findServiceBy_aroundBody3$advice(DefaultServicesManagerImpl ajc$this, Service service, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        RegisteredService registeredService;
        RegisteredService returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            registeredService = returnVal = DefaultServicesManagerImpl.findServiceBy_aroundBody2(ajc$this, service, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return registeredService;
    }

    private static final /* synthetic */ RegisteredService findServiceBy_aroundBody4(DefaultServicesManagerImpl ajc$this, long id, JoinPoint joinPoint) {
        RegisteredService r = ajc$this.services.get(id);
        try {
            return r == null ? null : (RegisteredService)r.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return r;
        }
    }

    private static final /* synthetic */ Object findServiceBy_aroundBody5$advice(DefaultServicesManagerImpl ajc$this, long id, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        RegisteredService registeredService;
        RegisteredService returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            registeredService = returnVal = DefaultServicesManagerImpl.findServiceBy_aroundBody4(ajc$this, id, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return registeredService;
    }

    private static final /* synthetic */ Collection getAllServices_aroundBody6(DefaultServicesManagerImpl ajc$this, JoinPoint joinPoint) {
        return Collections.unmodifiableCollection(ajc$this.services.values());
    }

    private static final /* synthetic */ Object getAllServices_aroundBody7$advice(DefaultServicesManagerImpl ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Collection collection;
        Collection returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            collection = returnVal = DefaultServicesManagerImpl.getAllServices_aroundBody6(ajc$this, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return collection;
    }

    private static final /* synthetic */ boolean matchesExistingService_aroundBody8(DefaultServicesManagerImpl ajc$this, Service service, JoinPoint joinPoint) {
        return ajc$this.findServiceBy(service) != null;
    }

    private static final /* synthetic */ Object matchesExistingService_aroundBody9$advice(DefaultServicesManagerImpl ajc$this, Service service, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)DefaultServicesManagerImpl.matchesExistingService_aroundBody8(ajc$this, service, (JoinPoint)proceedingJoinPoint2));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ RegisteredService save_aroundBody10(DefaultServicesManagerImpl ajc$this, RegisteredService registeredService, JoinPoint joinPoint) {
        RegisteredService r = ajc$this.serviceRegistryDao.save(registeredService);
        ajc$this.services.put(r.getId(), r);
        return r;
    }

    private static final /* synthetic */ Object save_aroundBody11$advice(DefaultServicesManagerImpl ajc$this, RegisteredService registeredService, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        RegisteredService registeredService2;
        RegisteredService returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            registeredService2 = returnVal = DefaultServicesManagerImpl.save_aroundBody10(ajc$this, registeredService, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return registeredService2;
    }

    private static final /* synthetic */ void reload_aroundBody12(DefaultServicesManagerImpl ajc$this, JoinPoint joinPoint) {
        ajc$this.log.info("Reloading registered services.");
        ajc$this.load();
    }

    private static final /* synthetic */ Object reload_aroundBody13$advice(DefaultServicesManagerImpl ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            DefaultServicesManagerImpl.reload_aroundBody12(ajc$this, (JoinPoint)proceedingJoinPoint2);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultServicesManagerImpl.java", DefaultServicesManagerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "delete", "org.jasig.cas.services.DefaultServicesManagerImpl", "long", "id", "", "org.jasig.cas.services.RegisteredService"), 76);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findServiceBy", "org.jasig.cas.services.DefaultServicesManagerImpl", "org.jasig.cas.authentication.principal.Service", "service", "", "org.jasig.cas.services.RegisteredService"), 93);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findServiceBy", "org.jasig.cas.services.DefaultServicesManagerImpl", "long", "id", "", "org.jasig.cas.services.RegisteredService"), 109);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllServices", "org.jasig.cas.services.DefaultServicesManagerImpl", "", "", "", "java.util.Collection"), 123);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "matchesExistingService", "org.jasig.cas.services.DefaultServicesManagerImpl", "org.jasig.cas.authentication.principal.Service", "service", "", "boolean"), 127);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "save", "org.jasig.cas.services.DefaultServicesManagerImpl", "org.jasig.cas.services.RegisteredService", "registeredService", "", "org.jasig.cas.services.RegisteredService"), 133);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reload", "org.jasig.cas.services.DefaultServicesManagerImpl", "", "", "", "void"), 139);
    }
}

