/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.monitor.TicketRegistryState;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JpaTicketRegistry
extends AbstractDistributedTicketRegistry
implements TicketRegistryState {
    @NotNull
    @PersistenceContext
    private EntityManager entityManager;
    @NotNull
    private String ticketGrantingTicketPrefix = "TGT";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    @Override
    protected void updateTicket(Ticket ticket) {
        this.entityManager.merge((Object)ticket);
        this.log.debug("Updated ticket [{}].", (Object)ticket);
    }

    @Override
    @Transactional(readOnly=false)
    public void addTicket(Ticket ticket) {
        Ticket ticket2 = ticket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ticket2);
        JpaTicketRegistry.addTicket_aroundBody1$advice(this, ticket2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    @Transactional(readOnly=false)
    public boolean deleteTicket(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        return Conversions.booleanValue((Object)JpaTicketRegistry.deleteTicket_aroundBody3$advice(this, string, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    private void deleteTicketAndChildren(Ticket ticket) {
        List ticketGrantingTicketImpls = this.entityManager.createQuery("select t from TicketGrantingTicketImpl t where t.ticketGrantingTicket.id = :id", TicketGrantingTicketImpl.class).setLockMode(LockModeType.PESSIMISTIC_WRITE).setParameter("id", (Object)ticket.getId()).getResultList();
        List serviceTicketImpls = this.entityManager.createQuery("select s from ServiceTicketImpl s where s.ticketGrantingTicket.id = :id", ServiceTicketImpl.class).setParameter("id", (Object)ticket.getId()).getResultList();
        for (ServiceTicketImpl s : serviceTicketImpls) {
            this.removeTicket(s);
        }
        for (TicketGrantingTicketImpl t : ticketGrantingTicketImpls) {
            this.deleteTicketAndChildren(t);
        }
        this.removeTicket(ticket);
    }

    private void removeTicket(Ticket ticket) {
        try {
            if (this.log.isDebugEnabled()) {
                Date creationDate = new Date(ticket.getCreationTime());
                this.log.debug("Removing Ticket [{}] created: {}", (Object)ticket, (Object)creationDate.toString());
            }
            this.entityManager.remove((Object)ticket);
        }
        catch (Exception e) {
            this.log.error("Error removing {} from registry.", (Object)ticket, (Object)e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Ticket getTicket(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        return (Ticket)JpaTicketRegistry.getTicket_aroundBody5$advice(this, string, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private Ticket getRawTicket(String ticketId) {
        try {
            if (ticketId.startsWith(this.ticketGrantingTicketPrefix)) {
                return (Ticket)this.entityManager.find(TicketGrantingTicketImpl.class, (Object)ticketId, LockModeType.PESSIMISTIC_WRITE);
            }
            return (Ticket)this.entityManager.find(ServiceTicketImpl.class, (Object)ticketId);
        }
        catch (Exception e) {
            this.log.error("Error getting ticket {} from registry.", (Object)ticketId, (Object)e);
            return null;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<Ticket> getTickets() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        return (Collection)JpaTicketRegistry.getTickets_aroundBody7$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void setTicketGrantingTicketPrefix(String ticketGrantingTicketPrefix) {
        this.ticketGrantingTicketPrefix = ticketGrantingTicketPrefix;
    }

    @Override
    protected boolean needsCallback() {
        return false;
    }

    @Override
    @Transactional(readOnly=true)
    public int sessionCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        return Conversions.intValue((Object)JpaTicketRegistry.sessionCount_aroundBody9$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @Override
    @Transactional(readOnly=true)
    public int serviceTicketCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        return Conversions.intValue((Object)JpaTicketRegistry.serviceTicketCount_aroundBody11$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    private int countToInt(Object result) {
        int intval = result instanceof Long ? ((Long)result).intValue() : (result instanceof Integer ? ((Integer)result).intValue() : ((Number)result).intValue());
        return intval;
    }

    static {
        JpaTicketRegistry.ajc$preClinit();
    }

    private static final /* synthetic */ void addTicket_aroundBody0(JpaTicketRegistry ajc$this, Ticket ticket, JoinPoint joinPoint) {
        ajc$this.entityManager.persist((Object)ticket);
        ajc$this.log.debug("Added ticket [{}] to registry.", (Object)ticket);
    }

    private static final /* synthetic */ Object addTicket_aroundBody1$advice(JpaTicketRegistry ajc$this, Ticket ticket, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            JpaTicketRegistry.addTicket_aroundBody0(ajc$this, ticket, (JoinPoint)proceedingJoinPoint2);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ boolean deleteTicket_aroundBody2(JpaTicketRegistry ajc$this, String ticketId, JoinPoint joinPoint) {
        Ticket ticket = ajc$this.getRawTicket(ticketId);
        if (ticket == null) {
            return false;
        }
        if (ticket instanceof ServiceTicket) {
            ajc$this.removeTicket(ticket);
            ajc$this.log.debug("Deleted ticket [{}] from the registry.", (Object)ticket);
            return true;
        }
        ajc$this.deleteTicketAndChildren(ticket);
        ajc$this.log.debug("Deleted ticket [{}] and its children from the registry.", (Object)ticket);
        return true;
    }

    private static final /* synthetic */ Object deleteTicket_aroundBody3$advice(JpaTicketRegistry ajc$this, String ticketId, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)JpaTicketRegistry.deleteTicket_aroundBody2(ajc$this, ticketId, (JoinPoint)proceedingJoinPoint2));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ Object getTicket_aroundBody5$advice(JpaTicketRegistry ajc$this, String ticketId, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Ticket ticket;
        Ticket returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            ticket = returnVal = ajc$this.getProxiedTicketInstance(ajc$this.getRawTicket(ticketId));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return ticket;
    }

    private static final /* synthetic */ Collection getTickets_aroundBody6(JpaTicketRegistry ajc$this, JoinPoint joinPoint) {
        List tgts = ajc$this.entityManager.createQuery("select t from TicketGrantingTicketImpl t", TicketGrantingTicketImpl.class).getResultList();
        List sts = ajc$this.entityManager.createQuery("select s from ServiceTicketImpl s", ServiceTicketImpl.class).getResultList();
        ArrayList tickets = new ArrayList();
        tickets.addAll(tgts);
        tickets.addAll(sts);
        return tickets;
    }

    private static final /* synthetic */ Object getTickets_aroundBody7$advice(JpaTicketRegistry ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Collection collection;
        Collection returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            collection = returnVal = JpaTicketRegistry.getTickets_aroundBody6(ajc$this, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return collection;
    }

    private static final /* synthetic */ Object sessionCount_aroundBody9$advice(JpaTicketRegistry ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.intObject((int)ajc$this.countToInt(ajc$this.entityManager.createQuery("select count(t) from TicketGrantingTicketImpl t").getSingleResult()));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ Object serviceTicketCount_aroundBody11$advice(JpaTicketRegistry ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.intObject((int)ajc$this.countToInt(ajc$this.entityManager.createQuery("select count(t) from ServiceTicketImpl t").getSingleResult()));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JpaTicketRegistry.java", JpaTicketRegistry.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTicket", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "org.jasig.cas.ticket.Ticket", "ticket", "", "void"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTicket", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "java.lang.String", "ticketId", "", "boolean"), 70);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTicket", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "java.lang.String", "ticketId", "", "org.jasig.cas.ticket.Ticket"), 123);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTickets", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "", "", "", "java.util.Collection"), 141);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "sessionCount", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "", "", "", "int"), 166);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "serviceTicketCount", "org.jasig.cas.ticket.registry.JpaTicketRegistry", "", "", "", "int"), 171);
    }
}

