/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SamlUtils {
    private static final String JSR_105_PROVIDER = "org.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private static final String SAML_PROTOCOL_NS_URI_V20 = "urn:oasis:names:tc:SAML:2.0:protocol";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    private SamlUtils() {
    }

    public static String getCurrentDateAndTime() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        return (String)SamlUtils.getCurrentDateAndTime_aroundBody1$advice(joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public static String getFormattedDateAndTime(Date date) {
        Date date2 = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)date2);
        return (String)SamlUtils.getFormattedDateAndTime_aroundBody3$advice(date2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public static String signSamlResponse(String samlResponse, PrivateKey privateKey, PublicKey publicKey) {
        String string = samlResponse;
        PrivateKey privateKey2 = privateKey;
        PublicKey publicKey2 = publicKey;
        Object[] objectArray = new Object[]{string, privateKey2, publicKey2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object[])objectArray);
        return (String)SamlUtils.signSamlResponse_aroundBody5$advice(string, privateKey2, publicKey2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public static Document constructDocumentFromXmlString(String xmlString) {
        String string = xmlString;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string);
        return (Document)SamlUtils.constructDocumentFromXmlString_aroundBody7$advice(string, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private static org.jdom.Element signSamlElement(org.jdom.Element element, PrivateKey privKey, PublicKey pubKey) {
        try {
            SignatureMethod signatureMethod;
            String providerName = System.getProperty("jsr105Provider", JSR_105_PROVIDER);
            XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
            List<Transform> envelopedTransform = Collections.singletonList(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            Reference ref = sigFactory.newReference("", sigFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), envelopedTransform, null, null);
            if (pubKey instanceof DSAPublicKey) {
                signatureMethod = sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
            } else if (pubKey instanceof RSAPublicKey) {
                signatureMethod = sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
            } else {
                throw new RuntimeException("Error signing SAML element: Unsupported type of key");
            }
            CanonicalizationMethod canonicalizationMethod = sigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
            SignedInfo signedInfo = sigFactory.newSignedInfo(canonicalizationMethod, signatureMethod, Collections.singletonList(ref));
            KeyInfoFactory keyInfoFactory = sigFactory.getKeyInfoFactory();
            KeyValue keyValuePair = keyInfoFactory.newKeyValue(pubKey);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyValuePair));
            Element w3cElement = SamlUtils.toDom(element);
            DOMSignContext dsc = new DOMSignContext(privKey, (Node)w3cElement);
            Node xmlSigInsertionPoint = SamlUtils.getXmlSignatureInsertLocation(w3cElement);
            dsc.setNextSibling(xmlSigInsertionPoint);
            XMLSignature signature = sigFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(dsc);
            return SamlUtils.toJdom(w3cElement);
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing SAML element: " + e.getMessage(), e);
        }
    }

    private static Node getXmlSignatureInsertLocation(Element elem) {
        Node insertLocation = null;
        NodeList nodeList = elem.getElementsByTagNameNS(SAML_PROTOCOL_NS_URI_V20, "Extensions");
        if (nodeList.getLength() != 0) {
            insertLocation = nodeList.item(nodeList.getLength() - 1);
        } else {
            nodeList = elem.getElementsByTagNameNS(SAML_PROTOCOL_NS_URI_V20, "Status");
            insertLocation = nodeList.item(nodeList.getLength() - 1);
        }
        return insertLocation;
    }

    private static Element toDom(org.jdom.Element element) {
        return SamlUtils.toDom(element.getDocument()).getDocumentElement();
    }

    private static org.w3c.dom.Document toDom(Document doc) {
        try {
            XMLOutputter xmlOutputter = new XMLOutputter();
            StringWriter elemStrWriter = new StringWriter();
            xmlOutputter.output(doc, (Writer)elemStrWriter);
            byte[] xmlBytes = elemStrWriter.toString().getBytes();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xmlBytes));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static org.jdom.Element toJdom(Element e) {
        return new DOMBuilder().build(e);
    }

    static {
        SamlUtils.ajc$preClinit();
    }

    private static final /* synthetic */ Object getCurrentDateAndTime_aroundBody1$advice(JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = SamlUtils.getFormattedDateAndTime(new Date());
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    private static final /* synthetic */ String getFormattedDateAndTime_aroundBody2(Date date, JoinPoint joinPoint) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return dateFormat.format(date);
    }

    private static final /* synthetic */ Object getFormattedDateAndTime_aroundBody3$advice(Date date, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = SamlUtils.getFormattedDateAndTime_aroundBody2(date, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    private static final /* synthetic */ String signSamlResponse_aroundBody4(String samlResponse, PrivateKey privateKey, PublicKey publicKey, JoinPoint joinPoint) {
        Document doc = SamlUtils.constructDocumentFromXmlString(samlResponse);
        if (doc != null) {
            org.jdom.Element signedElement = SamlUtils.signSamlElement(doc.getRootElement(), privateKey, publicKey);
            doc.setRootElement((org.jdom.Element)signedElement.detach());
            return new XMLOutputter().outputString(doc);
        }
        throw new RuntimeException("Error signing SAML Response: Null document");
    }

    private static final /* synthetic */ Object signSamlResponse_aroundBody5$advice(String samlResponse, PrivateKey privateKey, PublicKey publicKey, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = SamlUtils.signSamlResponse_aroundBody4(samlResponse, privateKey, publicKey, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    private static final /* synthetic */ Document constructDocumentFromXmlString_aroundBody6(String xmlString, JoinPoint joinPoint) {
        try {
            SAXBuilder builder = new SAXBuilder();
            return builder.build((InputStream)new ByteArrayInputStream(xmlString.getBytes()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final /* synthetic */ Object constructDocumentFromXmlString_aroundBody7$advice(String xmlString, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Document document;
        Document returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            document = returnVal = SamlUtils.constructDocumentFromXmlString_aroundBody6(xmlString, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return document;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SamlUtils.java", SamlUtils.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getCurrentDateAndTime", "org.jasig.cas.util.SamlUtils", "", "", "", "java.lang.String"), 75);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getFormattedDateAndTime", "org.jasig.cas.util.SamlUtils", "java.util.Date", "date", "", "java.lang.String"), 79);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "signSamlResponse", "org.jasig.cas.util.SamlUtils", "java.lang.String:java.security.PrivateKey:java.security.PublicKey", "samlResponse:privateKey:publicKey", "", "java.lang.String"), 87);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "constructDocumentFromXmlString", "org.jasig.cas.util.SamlUtils", "java.lang.String", "xmlString", "", "org.jdom.Document"), 100);
    }
}

