/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.principal.AbstractWebApplicationService;
import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.util.SamlUtils;
import org.jdom.Document;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class GoogleAccountsService
extends AbstractWebApplicationService {
    private static final long serialVersionUID = 6678711809842282833L;
    private static Random random;
    private static final char[] charMapping;
    private static final String CONST_PARAM_SERVICE = "SAMLRequest";
    private static final String CONST_RELAY_STATE = "RelayState";
    private static final String TEMPLATE_SAML_RESPONSE = "<samlp:Response ID=\"<RESPONSE_ID>\" IssueInstant=\"<ISSUE_INSTANT>\" Version=\"2.0\" xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><samlp:Status><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\" /></samlp:Status><Assertion ID=\"<ASSERTION_ID>\" IssueInstant=\"2003-04-17T00:46:02Z\" Version=\"2.0\" xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\"><Issuer>https://www.opensaml.org/IDP</Issuer><Subject><NameID Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:emailAddress\"><USERNAME_STRING></NameID><SubjectConfirmation Method=\"urn:oasis:names:tc:SAML:2.0:cm:bearer\"><SubjectConfirmationData Recipient=\"<ACS_URL>\" NotOnOrAfter=\"<NOT_ON_OR_AFTER>\" InResponseTo=\"<REQUEST_ID>\" /></SubjectConfirmation></Subject><Conditions NotBefore=\"2003-04-17T00:46:02Z\" NotOnOrAfter=\"<NOT_ON_OR_AFTER>\"><AudienceRestriction><Audience><ACS_URL></Audience></AudienceRestriction></Conditions><AuthnStatement AuthnInstant=\"<AUTHN_INSTANT>\"><AuthnContext><AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:Password</AuthnContextClassRef></AuthnContext></AuthnStatement></Assertion></samlp:Response>";
    private final String relayState;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private final String requestId;
    private final String alternateUserName;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        GoogleAccountsService.ajc$preClinit();
        random = new Random();
        charMapping = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
    }

    protected GoogleAccountsService(String id, String relayState, String requestId, PrivateKey privateKey, PublicKey publicKey, String alternateUserName) {
        this(id, id, null, relayState, requestId, privateKey, publicKey, alternateUserName);
    }

    protected GoogleAccountsService(String id, String originalUrl, String artifactId, String relayState, String requestId, PrivateKey privateKey, PublicKey publicKey, String alternateUserName) {
        super(id, originalUrl, artifactId, null);
        this.relayState = relayState;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.requestId = requestId;
        this.alternateUserName = alternateUserName;
    }

    public static GoogleAccountsService createServiceFrom(HttpServletRequest request, PrivateKey privateKey, PublicKey publicKey, String alternateUserName) {
        HttpServletRequest httpServletRequest = request;
        PrivateKey privateKey2 = privateKey;
        PublicKey publicKey2 = publicKey;
        String string = alternateUserName;
        Object[] objectArray = new Object[]{httpServletRequest, privateKey2, publicKey2, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        return (GoogleAccountsService)GoogleAccountsService.createServiceFrom_aroundBody1$advice(httpServletRequest, privateKey2, publicKey2, string, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public Response getResponse(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        return (Response)GoogleAccountsService.getResponse_aroundBody3$advice(this, string, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public boolean logOutOfService(String sessionIdentifier) {
        String string = sessionIdentifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        return Conversions.booleanValue((Object)GoogleAccountsService.logOutOfService_aroundBody5$advice(this, string, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    private String constructSamlResponse() {
        String attributeValue;
        String samlResponse = TEMPLATE_SAML_RESPONSE;
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(1, 1);
        String userId = this.alternateUserName == null ? this.getPrincipal().getId() : ((attributeValue = (String)this.getPrincipal().getAttributes().get(this.alternateUserName)) == null ? this.getPrincipal().getId() : attributeValue);
        samlResponse = samlResponse.replace("<USERNAME_STRING>", userId);
        samlResponse = samlResponse.replace("<RESPONSE_ID>", GoogleAccountsService.createID());
        samlResponse = samlResponse.replace("<ISSUE_INSTANT>", SamlUtils.getCurrentDateAndTime());
        samlResponse = samlResponse.replace("<AUTHN_INSTANT>", SamlUtils.getCurrentDateAndTime());
        samlResponse = samlResponse.replaceAll("<NOT_ON_OR_AFTER>", SamlUtils.getFormattedDateAndTime(c.getTime()));
        samlResponse = samlResponse.replace("<ASSERTION_ID>", GoogleAccountsService.createID());
        samlResponse = samlResponse.replaceAll("<ACS_URL>", this.getId());
        samlResponse = samlResponse.replace("<REQUEST_ID>", this.requestId);
        return samlResponse;
    }

    private static String createID() {
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        char[] chars = new char[40];
        int i = 0;
        while (i < bytes.length) {
            int left = bytes[i] >> 4 & 0xF;
            int right = bytes[i] & 0xF;
            chars[i * 2] = charMapping[left];
            chars[i * 2 + 1] = charMapping[right];
            ++i;
        }
        return String.valueOf(chars);
    }

    private static String decodeAuthnRequestXML(String encodedRequestXmlString) {
        if (encodedRequestXmlString == null) {
            return null;
        }
        byte[] decodedBytes = GoogleAccountsService.base64Decode(encodedRequestXmlString);
        if (decodedBytes == null) {
            return null;
        }
        String inflated = GoogleAccountsService.inflate(decodedBytes);
        if (inflated != null) {
            return inflated;
        }
        return GoogleAccountsService.zlibDeflate(decodedBytes);
    }

    /*
     * Loose catch block
     */
    private static String zlibDeflate(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InflaterInputStream iis = new InflaterInputStream(bais);
        byte[] buf = new byte[1024];
        int count = iis.read(buf);
        while (count != -1) {
            baos.write(buf, 0, count);
            count = iis.read(buf);
        }
        String string = new String(baos.toByteArray());
        try {
            iis.close();
        }
        catch (Exception exception) {}
        return string;
        catch (Exception exception) {
            try {}
            catch (Throwable throwable) {
                try {
                    iis.close();
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                iis.close();
            }
            catch (Exception exception3) {}
            return null;
        }
    }

    private static byte[] base64Decode(String xml) {
        try {
            byte[] xmlBytes = xml.getBytes("UTF-8");
            return Base64.decodeBase64((byte[])xmlBytes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String inflate(byte[] bytes) {
        Inflater inflater = new Inflater(true);
        byte[] xmlMessageBytes = new byte[10000];
        byte[] extendedBytes = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, extendedBytes, 0, bytes.length);
        extendedBytes[bytes.length] = 0;
        inflater.setInput(extendedBytes);
        try {
            int resultLength = inflater.inflate(xmlMessageBytes);
            inflater.end();
            if (!inflater.finished()) {
                throw new RuntimeException("buffer not large enough.");
            }
            inflater.end();
            return new String(xmlMessageBytes, 0, resultLength, "UTF-8");
        }
        catch (DataFormatException dataFormatException) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot find encoding: UTF-8", e);
        }
    }

    private static final /* synthetic */ GoogleAccountsService createServiceFrom_aroundBody0(HttpServletRequest request, PrivateKey privateKey, PublicKey publicKey, String alternateUserName, JoinPoint joinPoint) {
        String relayState = request.getParameter(CONST_RELAY_STATE);
        String xmlRequest = GoogleAccountsService.decodeAuthnRequestXML(request.getParameter(CONST_PARAM_SERVICE));
        if (!StringUtils.hasText((String)xmlRequest)) {
            return null;
        }
        Document document = SamlUtils.constructDocumentFromXmlString(xmlRequest);
        if (document == null) {
            return null;
        }
        String assertionConsumerServiceUrl = document.getRootElement().getAttributeValue("AssertionConsumerServiceURL");
        String requestId = document.getRootElement().getAttributeValue("ID");
        return new GoogleAccountsService(assertionConsumerServiceUrl, relayState, requestId, privateKey, publicKey, alternateUserName);
    }

    private static final /* synthetic */ Object createServiceFrom_aroundBody1$advice(HttpServletRequest request, PrivateKey privateKey, PublicKey publicKey, String alternateUserName, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        GoogleAccountsService googleAccountsService;
        GoogleAccountsService returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            googleAccountsService = returnVal = GoogleAccountsService.createServiceFrom_aroundBody0(request, privateKey, publicKey, alternateUserName, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? ((Object)returnVal).toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? ((Object)returnVal).toString() : "null") + "].");
        }
        return googleAccountsService;
    }

    private static final /* synthetic */ Response getResponse_aroundBody2(GoogleAccountsService ajc$this, String ticketId, JoinPoint joinPoint) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String samlResponse = ajc$this.constructSamlResponse();
        String signedResponse = SamlUtils.signSamlResponse(samlResponse, ajc$this.privateKey, ajc$this.publicKey);
        parameters.put("SAMLResponse", signedResponse);
        parameters.put(CONST_RELAY_STATE, ajc$this.relayState);
        return Response.getPostResponse(ajc$this.getOriginalUrl(), parameters);
    }

    private static final /* synthetic */ Object getResponse_aroundBody3$advice(GoogleAccountsService ajc$this, String ticketId, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Response response;
        Response returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            response = returnVal = GoogleAccountsService.getResponse_aroundBody2(ajc$this, ticketId, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return response;
    }

    private static final /* synthetic */ boolean logOutOfService_aroundBody4(GoogleAccountsService ajc$this, String sessionIdentifier, JoinPoint joinPoint) {
        return false;
    }

    private static final /* synthetic */ Object logOutOfService_aroundBody5$advice(GoogleAccountsService ajc$this, String sessionIdentifier, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)GoogleAccountsService.logOutOfService_aroundBody4(ajc$this, sessionIdentifier, (JoinPoint)proceedingJoinPoint2));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GoogleAccountsService.java", GoogleAccountsService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createServiceFrom", "org.jasig.cas.authentication.principal.GoogleAccountsService", "javax.servlet.http.HttpServletRequest:java.security.PrivateKey:java.security.PublicKey:java.lang.String", "request:privateKey:publicKey:alternateUserName", "", "org.jasig.cas.authentication.principal.GoogleAccountsService"), 127);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResponse", "org.jasig.cas.authentication.principal.GoogleAccountsService", "java.lang.String", "ticketId", "", "org.jasig.cas.authentication.principal.Response"), 153);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logOutOfService", "org.jasig.cas.authentication.principal.GoogleAccountsService", "java.lang.String", "sessionIdentifier", "", "boolean"), 169);
    }
}

