/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.AbstractTicket;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Entity
@Table(name="TICKETGRANTINGTICKET")
public final class TicketGrantingTicketImpl
extends AbstractTicket
implements TicketGrantingTicket {
    private static final long serialVersionUID = -5197946718924166491L;
    private static final Logger LOG;
    @Lob
    @Column(name="AUTHENTICATION", nullable=false)
    private Authentication authentication;
    @Column(name="EXPIRED", nullable=false)
    private Boolean expired = false;
    @Lob
    @Column(name="SERVICES_GRANTED_ACCESS_TO", nullable=false)
    private final HashMap<String, Service> services = new HashMap();
    @Column(name="PROXIED_BY", nullable=true)
    private String proxiedBy;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        TicketGrantingTicketImpl.ajc$preClinit();
        LOG = LoggerFactory.getLogger(TicketGrantingTicketImpl.class);
    }

    public TicketGrantingTicketImpl() {
    }

    public TicketGrantingTicketImpl(String id, String proxiedBy, TicketGrantingTicketImpl parentTicketGrantingTicket, Authentication authentication, ExpirationPolicy policy) {
        super(id, parentTicketGrantingTicket, policy);
        Assert.notNull((Object)authentication, (String)"authentication cannot be null");
        this.authentication = authentication;
        if (parentTicketGrantingTicket != null && proxiedBy == null) {
            throw new IllegalArgumentException("Must specify proxiedBy when providing parent TGT");
        }
        this.proxiedBy = proxiedBy;
    }

    public TicketGrantingTicketImpl(String id, Authentication authentication, ExpirationPolicy policy) {
        this(id, null, null, authentication, policy);
    }

    @Override
    public Authentication getAuthentication() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        return (Authentication)TicketGrantingTicketImpl.getAuthentication_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public String getProxiedBy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        return (String)TicketGrantingTicketImpl.getProxiedBy_aroundBody3$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public synchronized ServiceTicket grantServiceTicket(String id, Service service, ExpirationPolicy expirationPolicy, boolean credentialsProvided) {
        String string = id;
        Service service2 = service;
        ExpirationPolicy expirationPolicy2 = expirationPolicy;
        boolean bl = credentialsProvided;
        Object[] objectArray = new Object[]{string, service2, expirationPolicy2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        return (ServiceTicket)TicketGrantingTicketImpl.grantServiceTicket_aroundBody5$advice(this, string, service2, expirationPolicy2, bl, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private void logOutOfServices() {
        for (Map.Entry<String, Service> entry : this.services.entrySet()) {
            if (entry.getValue().logOutOfService(entry.getKey())) continue;
            LOG.warn("Logout message not sent to [" + entry.getValue().getId() + "]; Continuing processing...");
        }
    }

    @Override
    public boolean isRoot() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        return Conversions.booleanValue((Object)TicketGrantingTicketImpl.isRoot_aroundBody7$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @Override
    public synchronized void expire() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        TicketGrantingTicketImpl.expire_aroundBody9$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public boolean isExpiredInternal() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        return Conversions.booleanValue((Object)TicketGrantingTicketImpl.isExpiredInternal_aroundBody11$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @Override
    public List<Authentication> getChainedAuthentications() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        return (List)TicketGrantingTicketImpl.getChainedAuthentications_aroundBody13$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public final boolean equals(Object object) {
        Object object2 = object;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)object2);
        return Conversions.booleanValue((Object)TicketGrantingTicketImpl.equals_aroundBody15$advice(this, object2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    private static final /* synthetic */ Object getAuthentication_aroundBody1$advice(TicketGrantingTicketImpl ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Authentication authentication;
        Authentication returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            authentication = returnVal = ajc$this.authentication;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return authentication;
    }

    private static final /* synthetic */ Object getProxiedBy_aroundBody3$advice(TicketGrantingTicketImpl ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = ajc$this.proxiedBy;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    private static final /* synthetic */ ServiceTicket grantServiceTicket_aroundBody4(TicketGrantingTicketImpl ajc$this, String id, Service service, ExpirationPolicy expirationPolicy, boolean credentialsProvided, JoinPoint joinPoint) {
        ServiceTicketImpl serviceTicket = new ServiceTicketImpl(id, ajc$this, service, ajc$this.getCountOfUses() == 0 || credentialsProvided, expirationPolicy);
        ajc$this.updateState();
        List<Authentication> authentications = ajc$this.getChainedAuthentications();
        service.setPrincipal(authentications.get(authentications.size() - 1).getPrincipal());
        ajc$this.services.put(id, service);
        return serviceTicket;
    }

    private static final /* synthetic */ Object grantServiceTicket_aroundBody5$advice(TicketGrantingTicketImpl ajc$this, String id, Service service, ExpirationPolicy expirationPolicy, boolean credentialsProvided, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        ServiceTicket serviceTicket;
        ServiceTicket returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            serviceTicket = returnVal = TicketGrantingTicketImpl.grantServiceTicket_aroundBody4(ajc$this, id, service, expirationPolicy, credentialsProvided, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return serviceTicket;
    }

    private static final /* synthetic */ boolean isRoot_aroundBody6(TicketGrantingTicketImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.getGrantingTicket() == null;
    }

    private static final /* synthetic */ Object isRoot_aroundBody7$advice(TicketGrantingTicketImpl ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)TicketGrantingTicketImpl.isRoot_aroundBody6(ajc$this, (JoinPoint)proceedingJoinPoint2));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ void expire_aroundBody8(TicketGrantingTicketImpl ajc$this, JoinPoint joinPoint) {
        ajc$this.expired = true;
        ajc$this.logOutOfServices();
    }

    private static final /* synthetic */ Object expire_aroundBody9$advice(TicketGrantingTicketImpl ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            TicketGrantingTicketImpl.expire_aroundBody8(ajc$this, (JoinPoint)proceedingJoinPoint2);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ Object isExpiredInternal_aroundBody11$advice(TicketGrantingTicketImpl ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)ajc$this.expired);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ List getChainedAuthentications_aroundBody12(TicketGrantingTicketImpl ajc$this, JoinPoint joinPoint) {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        if (ajc$this.getGrantingTicket() == null) {
            list.add(ajc$this.getAuthentication());
            return Collections.unmodifiableList(list);
        }
        list.add(ajc$this.getAuthentication());
        list.addAll(ajc$this.getGrantingTicket().getChainedAuthentications());
        return Collections.unmodifiableList(list);
    }

    private static final /* synthetic */ Object getChainedAuthentications_aroundBody13$advice(TicketGrantingTicketImpl ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        List list;
        List returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            list = returnVal = TicketGrantingTicketImpl.getChainedAuthentications_aroundBody12(ajc$this, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return list;
    }

    private static final /* synthetic */ boolean equals_aroundBody14(TicketGrantingTicketImpl ajc$this, Object object, JoinPoint joinPoint) {
        if (object == null || !(object instanceof TicketGrantingTicket)) {
            return false;
        }
        Ticket ticket = (Ticket)object;
        return ticket.getId().equals(ajc$this.getId());
    }

    private static final /* synthetic */ Object equals_aroundBody15$advice(TicketGrantingTicketImpl ajc$this, Object object, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object2;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object2 = returnVal = Conversions.booleanObject((boolean)TicketGrantingTicketImpl.equals_aroundBody14(ajc$this, object, (JoinPoint)proceedingJoinPoint2));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object2;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TicketGrantingTicketImpl.java", TicketGrantingTicketImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAuthentication", "org.jasig.cas.ticket.TicketGrantingTicketImpl", "", "", "", "org.jasig.cas.authentication.Authentication"), 118);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProxiedBy", "org.jasig.cas.ticket.TicketGrantingTicketImpl", "", "", "", "java.lang.String"), 122);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "grantServiceTicket", "org.jasig.cas.ticket.TicketGrantingTicketImpl", "java.lang.String:org.jasig.cas.authentication.principal.Service:org.jasig.cas.ticket.ExpirationPolicy:boolean", "id:service:expirationPolicy:credentialsProvided", "", "org.jasig.cas.ticket.ServiceTicket"), 126);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isRoot", "org.jasig.cas.ticket.TicketGrantingTicketImpl", "", "", "", "boolean"), 152);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "expire", "org.jasig.cas.ticket.TicketGrantingTicketImpl", "", "", "", "void"), 156);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isExpiredInternal", "org.jasig.cas.ticket.TicketGrantingTicketImpl", "", "", "", "boolean"), 161);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getChainedAuthentications", "org.jasig.cas.ticket.TicketGrantingTicketImpl", "", "", "", "java.util.List"), 165);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "equals", "org.jasig.cas.ticket.TicketGrantingTicketImpl", "java.lang.Object", "object", "", "boolean"), 179);
    }
}

