/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;

public class AcceptUsersAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @NotNull
    private Map<String, String> users;

    @Override
    protected final Principal authenticateUsernamePasswordInternal(String username, String password) throws GeneralSecurityException, PreventedException {
        String cachedPassword = this.users.get(username);
        if (cachedPassword == null) {
            this.logger.debug("{} was not found in the map.", (Object)username);
            throw new AccountNotFoundException(username + " not found in backing map.");
        }
        String encodedPassword = this.getPasswordEncoder().encode(password);
        if (!cachedPassword.equals(encodedPassword)) {
            throw new FailedLoginException();
        }
        return new SimplePrincipal(username);
    }

    public final void setUsers(Map<String, String> users) {
        this.users = Collections.unmodifiableMap(users);
    }
}

