/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.remoting.server;

import java.util.List;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.validation.Assertion;
import org.springframework.util.Assert;

public final class RemoteCentralAuthenticationService
implements CentralAuthenticationService {
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    @Override
    public String createTicketGrantingTicket(Credential ... credentials) throws AuthenticationException, TicketException {
        Assert.notNull((Object)credentials, (String)"credentials cannot be null");
        this.checkForErrors(credentials);
        return this.centralAuthenticationService.createTicketGrantingTicket(credentials);
    }

    @Override
    public String grantServiceTicket(String ticketGrantingTicketId, Service service) throws TicketException {
        return this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, service);
    }

    @Override
    public String grantServiceTicket(String ticketGrantingTicketId, Service service, Credential ... credentials) throws AuthenticationException, TicketException {
        this.checkForErrors(credentials);
        return this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, service, credentials);
    }

    @Override
    public Assertion validateServiceTicket(String serviceTicketId, Service service) throws TicketException {
        return this.centralAuthenticationService.validateServiceTicket(serviceTicketId, service);
    }

    @Override
    public List<LogoutRequest> destroyTicketGrantingTicket(String ticketGrantingTicketId) {
        return this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
    }

    @Override
    public String delegateTicketGrantingTicket(String serviceTicketId, Credential ... credentials) throws AuthenticationException, TicketException {
        this.checkForErrors(credentials);
        return this.centralAuthenticationService.delegateTicketGrantingTicket(serviceTicketId, credentials);
    }

    private void checkForErrors(Credential ... credentials) {
        if (credentials == null) {
            return;
        }
        for (Credential c : credentials) {
            Set errors = this.validator.validate((Object)c, new Class[0]);
            if (errors.isEmpty()) continue;
            throw new IllegalArgumentException("Error validating credentials: " + errors.toString());
        }
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

