/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import com.github.inspektr.audit.annotation.Audit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.ServiceRegistryDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public final class DefaultServicesManagerImpl
implements ReloadableServicesManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private ServiceRegistryDao serviceRegistryDao;
    private ConcurrentHashMap<Long, RegisteredService> services = new ConcurrentHashMap();

    public DefaultServicesManagerImpl(ServiceRegistryDao serviceRegistryDao) {
        this(serviceRegistryDao, new ArrayList<String>());
    }

    public DefaultServicesManagerImpl(ServiceRegistryDao serviceRegistryDao, List<String> defaultAttributes) {
        this.serviceRegistryDao = serviceRegistryDao;
        this.load();
    }

    @Override
    @Transactional(readOnly=false)
    @Audit(action="DELETE_SERVICE", actionResolverName="DELETE_SERVICE_ACTION_RESOLVER", resourceResolverName="DELETE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService delete(long id) {
        RegisteredService r = this.findServiceBy(id);
        if (r == null) {
            return null;
        }
        this.serviceRegistryDao.delete(r);
        this.services.remove(id);
        return r;
    }

    @Override
    public RegisteredService findServiceBy(Service service) {
        TreeSet<RegisteredService> c = this.convertToTreeSet();
        for (RegisteredService r : c) {
            if (!r.matches(service)) continue;
            return r;
        }
        return null;
    }

    @Override
    public RegisteredService findServiceBy(long id) {
        RegisteredService r = this.services.get(id);
        try {
            return r == null ? null : r.clone();
        }
        catch (CloneNotSupportedException e) {
            return r;
        }
    }

    protected TreeSet<RegisteredService> convertToTreeSet() {
        return new TreeSet<RegisteredService>(this.services.values());
    }

    @Override
    public Collection<RegisteredService> getAllServices() {
        return Collections.unmodifiableCollection(this.convertToTreeSet());
    }

    @Override
    public boolean matchesExistingService(Service service) {
        return this.findServiceBy(service) != null;
    }

    @Override
    @Transactional(readOnly=false)
    @Audit(action="SAVE_SERVICE", actionResolverName="SAVE_SERVICE_ACTION_RESOLVER", resourceResolverName="SAVE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService save(RegisteredService registeredService) {
        RegisteredService r = this.serviceRegistryDao.save(registeredService);
        this.services.put(r.getId(), r);
        return r;
    }

    @Override
    public void reload() {
        this.logger.info("Reloading registered services.");
        this.load();
    }

    private void load() {
        ConcurrentHashMap<Long, RegisteredService> localServices = new ConcurrentHashMap<Long, RegisteredService>();
        for (RegisteredService r : this.serviceRegistryDao.load()) {
            this.logger.debug("Adding registered service {}", (Object)r.getServiceId());
            localServices.put(r.getId(), r);
        }
        this.services = localServices;
        this.logger.info(String.format("Loaded %s services.", this.services.size()));
    }
}

