/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.jasig.cas.CentralAuthenticationServiceImpl;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.jasig.cas.validation.Assertion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralAuthenticationServiceImplWithMokitoTests {
    private static final String TGT_ID = "tgt-id";
    private static final String TGT2_ID = "tgt2-id";
    private static final String ST_ID = "st-id";
    private static final String ST2_ID = "st2-id";
    private static final String SVC1_ID = "test1";
    private static final String SVC2_ID = "test2";
    private static final String PRINCIPAL = "principal";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CentralAuthenticationServiceImpl cas;
    private Authentication authentication;

    @Before
    public void prepareNewCAS() {
        this.authentication = (Authentication)Mockito.mock(Authentication.class);
        Mockito.when((Object)this.authentication.getAuthenticatedDate()).thenReturn((Object)new Date());
        BasicCredentialMetaData metadata = new BasicCredentialMetaData((Credential)TestUtils.getCredentialsWithSameUsernameAndPassword(PRINCIPAL));
        HashMap<String, HandlerResult> successes = new HashMap<String, HandlerResult>();
        successes.put("handler1", new HandlerResult((AuthenticationHandler)Mockito.mock(AuthenticationHandler.class), (CredentialMetaData)metadata));
        Mockito.when((Object)this.authentication.getCredentials()).thenReturn(Arrays.asList(metadata));
        Mockito.when((Object)this.authentication.getSuccesses()).thenReturn(successes);
        Mockito.when((Object)this.authentication.getPrincipal()).thenReturn((Object)new SimplePrincipal(PRINCIPAL));
        ServiceTicket stMock = (ServiceTicket)Mockito.mock(ServiceTicket.class);
        Mockito.when((Object)stMock.getService()).thenReturn((Object)TestUtils.getService());
        Mockito.when((Object)stMock.getId()).thenReturn((Object)ST_ID);
        Mockito.when((Object)stMock.isValidFor(TestUtils.getService())).thenReturn((Object)true);
        TicketGrantingTicket tgtRootMock = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)tgtRootMock.isExpired()).thenReturn((Object)false);
        Mockito.when((Object)tgtRootMock.getAuthentication()).thenReturn((Object)this.authentication);
        TicketGrantingTicket tgtMock = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)tgtMock.isExpired()).thenReturn((Object)false);
        Mockito.when((Object)tgtMock.getId()).thenReturn((Object)TGT_ID);
        Mockito.when((Object)tgtMock.grantServiceTicket(Mockito.anyString(), (Service)Mockito.argThat((Matcher)new VerifyServiceByIdMatcher(TestUtils.getService().getId())), (ExpirationPolicy)Mockito.any(ExpirationPolicy.class), Mockito.anyBoolean())).thenReturn((Object)stMock);
        Mockito.when((Object)tgtMock.getRoot()).thenReturn((Object)tgtRootMock);
        List authnListMock = (List)Mockito.mock(List.class);
        Mockito.when((Object)authnListMock.size()).thenReturn((Object)2);
        Mockito.when(authnListMock.get(Mockito.anyInt())).thenReturn((Object)this.authentication);
        Mockito.when((Object)tgtMock.getChainedAuthentications()).thenReturn((Object)authnListMock);
        Mockito.when((Object)stMock.getGrantingTicket()).thenReturn((Object)tgtMock);
        Service service2 = TestUtils.getService(SVC2_ID);
        ServiceTicket stMock2 = (ServiceTicket)Mockito.mock(ServiceTicket.class);
        Mockito.when((Object)stMock2.getService()).thenReturn((Object)service2);
        Mockito.when((Object)stMock2.getId()).thenReturn((Object)ST2_ID);
        Mockito.when((Object)stMock2.isValidFor(service2)).thenReturn((Object)true);
        TicketGrantingTicket tgtMock2 = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)tgtMock2.isExpired()).thenReturn((Object)false);
        Mockito.when((Object)tgtMock2.getId()).thenReturn((Object)TGT2_ID);
        Mockito.when((Object)tgtMock2.grantServiceTicket(Mockito.anyString(), (Service)Mockito.argThat((Matcher)new VerifyServiceByIdMatcher(service2.getId())), (ExpirationPolicy)Mockito.any(ExpirationPolicy.class), Mockito.anyBoolean())).thenReturn((Object)stMock2);
        Mockito.when((Object)tgtMock2.getRoot()).thenReturn((Object)tgtRootMock);
        Mockito.when((Object)tgtMock2.getChainedAuthentications()).thenReturn((Object)authnListMock);
        Mockito.when((Object)stMock2.getGrantingTicket()).thenReturn((Object)tgtMock2);
        TicketRegistry ticketRegMock = (TicketRegistry)Mockito.mock(TicketRegistry.class);
        Mockito.when((Object)ticketRegMock.getTicket((String)Mockito.eq((Object)tgtMock.getId()), (Class)Mockito.eq(TicketGrantingTicket.class))).thenReturn((Object)tgtMock);
        Mockito.when((Object)ticketRegMock.getTicket((String)Mockito.eq((Object)tgtMock2.getId()), (Class)Mockito.eq(TicketGrantingTicket.class))).thenReturn((Object)tgtMock2);
        Mockito.when((Object)ticketRegMock.getTicket((String)Mockito.eq((Object)stMock.getId()), (Class)Mockito.eq(ServiceTicket.class))).thenReturn((Object)stMock);
        Mockito.when((Object)ticketRegMock.getTicket((String)Mockito.eq((Object)stMock2.getId()), (Class)Mockito.eq(ServiceTicket.class))).thenReturn((Object)stMock2);
        RegisteredService mockRegSvc1 = (RegisteredService)Mockito.mock(RegisteredService.class);
        Mockito.when((Object)mockRegSvc1.getServiceId()).thenReturn((Object)SVC1_ID);
        Mockito.when((Object)mockRegSvc1.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockRegSvc1.isAllowedToProxy()).thenReturn((Object)false);
        Mockito.when((Object)mockRegSvc1.getName()).thenReturn((Object)SVC1_ID);
        RegisteredService mockRegSvc2 = (RegisteredService)Mockito.mock(RegisteredService.class);
        Mockito.when((Object)mockRegSvc2.getServiceId()).thenReturn((Object)"test");
        Mockito.when((Object)mockRegSvc2.isEnabled()).thenReturn((Object)false);
        Mockito.when((Object)mockRegSvc2.getName()).thenReturn((Object)"test");
        RegisteredService mockRegSvc3 = (RegisteredService)Mockito.mock(RegisteredService.class);
        Mockito.when((Object)mockRegSvc3.getServiceId()).thenReturn((Object)service2.getId());
        Mockito.when((Object)mockRegSvc3.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockRegSvc3.isAllowedToProxy()).thenReturn((Object)true);
        Mockito.when((Object)mockRegSvc3.getName()).thenReturn((Object)service2.getId());
        Mockito.when((Object)mockRegSvc3.matches((Service)Mockito.argThat((Matcher)new VerifyServiceByIdMatcher(service2.getId())))).thenReturn((Object)true);
        ServicesManager smMock = (ServicesManager)Mockito.mock(ServicesManager.class);
        Mockito.when((Object)smMock.findServiceBy((Service)Mockito.argThat((Matcher)new VerifyServiceByIdMatcher(SVC1_ID)))).thenReturn((Object)mockRegSvc1);
        Mockito.when((Object)smMock.findServiceBy((Service)Mockito.argThat((Matcher)new VerifyServiceByIdMatcher("test")))).thenReturn((Object)mockRegSvc2);
        Mockito.when((Object)smMock.findServiceBy((Service)Mockito.argThat((Matcher)new VerifyServiceByIdMatcher(SVC2_ID)))).thenReturn((Object)mockRegSvc3);
        Map ticketIdGenForServiceMock = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)ticketIdGenForServiceMock.containsKey(Mockito.any())).thenReturn((Object)true);
        Mockito.when(ticketIdGenForServiceMock.get(Mockito.any())).thenReturn((Object)new DefaultUniqueTicketIdGenerator());
        this.cas = new CentralAuthenticationServiceImpl(ticketRegMock, null, (AuthenticationManager)Mockito.mock(AuthenticationManager.class), (UniqueTicketIdGenerator)Mockito.mock(UniqueTicketIdGenerator.class), ticketIdGenForServiceMock, (ExpirationPolicy)Mockito.mock(ExpirationPolicy.class), (ExpirationPolicy)Mockito.mock(ExpirationPolicy.class), smMock, (LogoutManager)Mockito.mock(LogoutManager.class));
    }

    @Test(expected=InvalidTicketException.class)
    public void testNonExistentServiceWhenDelegatingTicketGrantingTicket() throws Exception {
        this.cas.delegateTicketGrantingTicket("bad-st", new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
    }

    @Test(expected=UnauthorizedServiceException.class)
    public void testInvalidServiceWhenDelegatingTicketGrantingTicket() throws Exception {
        this.cas.delegateTicketGrantingTicket(ST_ID, new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
    }

    @Test(expected=UnauthorizedProxyingException.class)
    public void disallowVendingServiceTicketsWhenServiceIsNotAllowedToProxyCAS1019() throws TicketException {
        this.cas.grantServiceTicket(TGT_ID, TestUtils.getService(SVC1_ID));
    }

    @Test
    public void testChainedAuthenticationsOnValidation() throws TicketException {
        Service svc = TestUtils.getService(SVC2_ID);
        String st = this.cas.grantServiceTicket(TGT2_ID, svc);
        Assert.assertNotNull((Object)st);
        Assertion assertion = this.cas.validateServiceTicket(st, svc);
        Assert.assertNotNull((Object)assertion);
        Assert.assertEquals((Object)assertion.getService(), (Object)svc);
        Assert.assertEquals((Object)assertion.getPrimaryAuthentication().getPrincipal().getId(), (Object)PRINCIPAL);
        Assert.assertTrue((assertion.getChainedAuthentications().size() == 2 ? 1 : 0) != 0);
        for (int i = 0; i < assertion.getChainedAuthentications().size(); ++i) {
            Authentication auth = (Authentication)assertion.getChainedAuthentications().get(i);
            Assert.assertEquals((Object)auth, (Object)this.authentication);
        }
    }

    private static class VerifyServiceByIdMatcher
    extends ArgumentMatcher<Service> {
        private String id;

        public VerifyServiceByIdMatcher(String id) {
            this.id = id;
        }

        public boolean matches(Object argument) {
            Service s = (Service)argument;
            return s != null && s.getId().equals(this.id);
        }
    }
}

