/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.mock.MockService;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.JpaTicketRegistry;
import org.jasig.cas.ticket.support.HardTimeoutExpirationPolicy;
import org.jasig.cas.ticket.support.MultiTimeUseOrTimeoutExpirationPolicy;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.annotation.IfProfileValue;
import org.springframework.test.annotation.ProfileValueSourceConfiguration;
import org.springframework.test.annotation.SystemProfileValueSource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.jdbc.JdbcTestUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"/jpaTestApplicationContext.xml"})
@ProfileValueSourceConfiguration(value=SystemProfileValueSource.class)
public class JpaTicketRegistryTests {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int CONCURRENT_SIZE = 20;
    private static UniqueTicketIdGenerator ID_GENERATOR = new DefaultUniqueTicketIdGenerator(64);
    private static ExpirationPolicy EXP_POLICY_TGT = new HardTimeoutExpirationPolicy(1000L);
    private static ExpirationPolicy EXP_POLICY_ST = new MultiTimeUseOrTimeoutExpirationPolicy(1, 1000L);
    @Autowired
    private PlatformTransactionManager txManager;
    @Autowired
    private JpaTicketRegistry jpaTicketRegistry;
    private JdbcTemplate simpleJdbcTemplate;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Before
    public void setUp() {
        JdbcTestUtils.deleteFromTables((JdbcTemplate)this.simpleJdbcTemplate, (String[])new String[]{"SERVICETICKET"});
        JdbcTestUtils.deleteFromTables((JdbcTemplate)this.simpleJdbcTemplate, (String[])new String[]{"TICKETGRANTINGTICKET"});
    }

    @Test
    public void testTicketCreationAndDeletion() throws Exception {
        TicketGrantingTicket newTgt = JpaTicketRegistryTests.newTGT();
        this.addTicketInTransaction((Ticket)newTgt);
        TicketGrantingTicket tgtFromDb = (TicketGrantingTicket)this.getTicketInTransaction(newTgt.getId());
        Assert.assertNotNull((Object)tgtFromDb);
        Assert.assertEquals((Object)newTgt.getId(), (Object)tgtFromDb.getId());
        ServiceTicket newSt = this.grantServiceTicketInTransaction(tgtFromDb);
        ServiceTicket stFromDb = (ServiceTicket)this.getTicketInTransaction(newSt.getId());
        Assert.assertNotNull((Object)stFromDb);
        Assert.assertEquals((Object)newSt.getId(), (Object)stFromDb.getId());
        this.deleteTicketInTransaction(newTgt.getId());
        Assert.assertNull((Object)this.getTicketInTransaction(newTgt.getId()));
        Assert.assertNull((Object)this.getTicketInTransaction(newSt.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @IfProfileValue(name="cas.jpa.concurrent", value="true")
    public void testConcurrentServiceTicketGeneration() throws Exception {
        TicketGrantingTicket newTgt = JpaTicketRegistryTests.newTGT();
        this.addTicketInTransaction((Ticket)newTgt);
        ExecutorService executor = Executors.newFixedThreadPool(20);
        try {
            ArrayList<ServiceTicketGenerator> generators = new ArrayList<ServiceTicketGenerator>(20);
            for (int i = 0; i < 20; ++i) {
                generators.add(new ServiceTicketGenerator(newTgt.getId()));
            }
            List results = executor.invokeAll(generators);
            for (Future result : results) {
                Assert.assertNotNull(result.get());
            }
        }
        catch (Exception e) {
            this.logger.debug("testConcurrentServiceTicketGeneration produced an error", (Throwable)e);
            Assert.fail((String)"testConcurrentServiceTicketGeneration failed.");
        }
        finally {
            executor.shutdownNow();
        }
    }

    static TicketGrantingTicket newTGT() {
        SimplePrincipal principal = new SimplePrincipal("bob", Collections.singletonMap("displayName", "Bob"));
        return new TicketGrantingTicketImpl(ID_GENERATOR.getNewTicketId("TGT"), TestUtils.getAuthentication((Principal)principal), EXP_POLICY_TGT);
    }

    static ServiceTicket newST(TicketGrantingTicket parent) {
        return parent.grantServiceTicket(ID_GENERATOR.getNewTicketId("ST"), (Service)new MockService("https://service.example.com"), EXP_POLICY_ST, false);
    }

    void addTicketInTransaction(final Ticket ticket) {
        new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                JpaTicketRegistryTests.this.jpaTicketRegistry.addTicket(ticket);
                return null;
            }
        });
    }

    void deleteTicketInTransaction(final String ticketId) {
        new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                JpaTicketRegistryTests.this.jpaTicketRegistry.deleteTicket(ticketId);
                return null;
            }
        });
    }

    Ticket getTicketInTransaction(final String ticketId) {
        return (Ticket)new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<Ticket>(){

            public Ticket doInTransaction(TransactionStatus status) {
                return JpaTicketRegistryTests.this.jpaTicketRegistry.getTicket(ticketId);
            }
        });
    }

    ServiceTicket grantServiceTicketInTransaction(final TicketGrantingTicket parent) {
        return (ServiceTicket)new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<ServiceTicket>(){

            public ServiceTicket doInTransaction(TransactionStatus status) {
                ServiceTicket st = JpaTicketRegistryTests.newST(parent);
                JpaTicketRegistryTests.this.jpaTicketRegistry.addTicket((Ticket)st);
                return st;
            }
        });
    }

    class ServiceTicketGenerator
    implements Callable<String> {
        private String parentTgtId;

        public ServiceTicketGenerator(String tgtId) {
            this.parentTgtId = tgtId;
        }

        @Override
        public String call() throws Exception {
            return (String)new TransactionTemplate(JpaTicketRegistryTests.this.txManager).execute((TransactionCallback)new TransactionCallback<String>(){

                public String doInTransaction(TransactionStatus status) {
                    ServiceTicket st = JpaTicketRegistryTests.newST((TicketGrantingTicket)JpaTicketRegistryTests.this.jpaTicketRegistry.getTicket(ServiceTicketGenerator.this.parentTgtId));
                    JpaTicketRegistryTests.this.jpaTicketRegistry.addTicket((Ticket)st);
                    return st.getId();
                }
            });
        }
    }
}

