/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.init;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jasig.cas.web.init.SafeDispatcherServlet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.context.ApplicationContextException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;

public class SafeDispatcherServletTests {
    private SafeDispatcherServlet safeServlet;
    private ServletContext mockContext;
    private MockServletConfig mockConfig;

    @Before
    public void setUp() throws Exception {
        this.safeServlet = new SafeDispatcherServlet();
        this.mockContext = new MockServletContext();
        this.mockConfig = new MockServletConfig(this.mockContext);
    }

    @Test
    public void testInitServletConfig() {
        this.safeServlet.init((ServletConfig)this.mockConfig);
        BeanDefinitionStoreException bdse = (BeanDefinitionStoreException)this.mockContext.getAttribute("exceptionCaughtByServlet");
        Assert.assertNotNull((Object)bdse);
    }

    @Test
    public void testService() throws ServletException, IOException {
        this.safeServlet.init((ServletConfig)this.mockConfig);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        try {
            this.safeServlet.service((ServletRequest)mockRequest, (ServletResponse)mockResponse);
        }
        catch (ApplicationContextException ace) {
            return;
        }
        Assert.fail((String)"Should have thrown ApplicationContextException since init() failed.");
    }

    @Test
    public void testServiceSucceeds() {
        this.mockConfig = new MockServletConfig(this.mockContext, "cas");
        this.safeServlet.init((ServletConfig)this.mockConfig);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        try {
            this.safeServlet.service((ServletRequest)mockRequest, (ServletResponse)mockResponse);
        }
        catch (ApplicationContextException e) {
            Assert.fail((String)"Unexpected exception.");
        }
        catch (Exception e) {
            return;
        }
    }
}

