/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.jmx;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.ServicesManager;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.util.Assert;

public abstract class AbstractServicesManagerMBean<T extends ServicesManager> {
    @NotNull
    private T servicesManager;

    protected AbstractServicesManagerMBean(T svcMgr) {
        this.servicesManager = svcMgr;
    }

    protected final T getServicesManager() {
        return this.servicesManager;
    }

    @ManagedAttribute(description="Retrieves the list of Registered Services in a slightly friendlier output.")
    public final List<String> getRegisteredServicesAsStrings() {
        ArrayList<String> services = new ArrayList<String>();
        for (RegisteredService r : this.servicesManager.getAllServices()) {
            services.add("id: " + r.getId() + " name: " + r.getName() + " enabled: " + r.isEnabled() + " ssoEnabled: " + r.isSsoEnabled() + " serviceId: " + r.getServiceId());
        }
        return services;
    }

    @ManagedOperation(description="Can remove a service based on its identifier.")
    @ManagedOperationParameter(name="id", description="the identifier to remove")
    public final RegisteredService removeService(long id) {
        return this.servicesManager.delete(id);
    }

    @ManagedOperation(description="Disable a service by id.")
    @ManagedOperationParameter(name="id", description="the identifier to disable")
    public final void disableService(long id) {
        this.changeEnabledState(id, false);
    }

    @ManagedOperation(description="Enable a service by its id.")
    @ManagedOperationParameter(name="id", description="the identifier to enable.")
    public final void enableService(long id) {
        this.changeEnabledState(id, true);
    }

    private void changeEnabledState(long id, boolean newState) {
        RegisteredService r = this.servicesManager.findServiceBy(id);
        Assert.notNull((Object)r, (String)"invalid RegisteredService id");
        ((RegisteredServiceImpl)r).setEnabled(newState);
        this.servicesManager.save(r);
    }
}

