/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.init;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ContextLoaderListener;

public final class SafeContextLoaderListener
implements ServletContextListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String CAUGHT_THROWABLE_KEY = "exceptionCaughtByListener";
    private final ContextLoaderListener delegate = new ContextLoaderListener();

    public void contextInitialized(ServletContextEvent sce) {
        try {
            this.delegate.contextInitialized(sce);
        }
        catch (Throwable t) {
            String message = "SafeContextLoaderListener: \nThe Spring ContextLoaderListener we wrap threw on contextInitialized.\nBut for our having caught this error, the web application context would not have initialized.";
            this.logger.error("SafeContextLoaderListener: \nThe Spring ContextLoaderListener we wrap threw on contextInitialized.\nBut for our having caught this error, the web application context would not have initialized.", t);
            ServletContext context = sce.getServletContext();
            context.log("SafeContextLoaderListener: \nThe Spring ContextLoaderListener we wrap threw on contextInitialized.\nBut for our having caught this error, the web application context would not have initialized.", t);
            context.setAttribute(CAUGHT_THROWABLE_KEY, (Object)t);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.delegate.contextDestroyed(sce);
    }
}

