/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler;

import org.jasig.cas.authentication.handler.DefaultPasswordEncoder;
import org.jasig.cas.authentication.handler.PasswordEncoder;
import org.junit.Assert;
import org.junit.Test;

public final class DefaultPasswordEncoderTests {
    private final PasswordEncoder passwordEncoder = new DefaultPasswordEncoder("MD5");

    @Test
    public void testNullPassword() {
        Assert.assertEquals(null, (Object)this.passwordEncoder.encode(null));
    }

    @Test
    public void testMd5Hash() {
        Assert.assertEquals((Object)"1f3870be274f6c49b3e31a0c6728957f", (Object)this.passwordEncoder.encode("apple"));
    }

    @Test
    public void testSha1Hash() {
        DefaultPasswordEncoder pe = new DefaultPasswordEncoder("SHA1");
        String hash = pe.encode("this is a test");
        Assert.assertEquals((Object)"fa26be19de6bff93f70bc2308434e4a440bbad02", (Object)hash);
    }

    @Test
    public void testSha1Hash2() {
        DefaultPasswordEncoder pe = new DefaultPasswordEncoder("SHA1");
        String hash = pe.encode("TEST of the SYSTEM");
        Assert.assertEquals((Object)"82ae28dfad565dd9882b94498a271caa29025d5f", (Object)hash);
    }

    @Test
    public void testInvalidEncodingType() {
        DefaultPasswordEncoder pe = new DefaultPasswordEncoder("scott");
        try {
            pe.encode("test");
            Assert.fail((String)"exception expected.");
        }
        catch (Exception e) {
            return;
        }
    }
}

