/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class SimpleWebApplicationServiceImplTests {
    @Test
    public void testResponse() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "service");
        SimpleWebApplicationServiceImpl impl = SimpleWebApplicationServiceImpl.createServiceFrom((HttpServletRequest)request);
        Response response = impl.getResponse("ticketId");
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)Response.ResponseType.REDIRECT, (Object)response.getResponseType());
    }

    @Test
    public void testResponseForJsession() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "http://www.cnn.com/;jsession=test");
        SimpleWebApplicationServiceImpl impl = SimpleWebApplicationServiceImpl.createServiceFrom((HttpServletRequest)request);
        Assert.assertEquals((Object)"http://www.cnn.com/", (Object)impl.getId());
    }

    @Test
    public void testResponseWithNoTicket() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "service");
        SimpleWebApplicationServiceImpl impl = SimpleWebApplicationServiceImpl.createServiceFrom((HttpServletRequest)request);
        Response response = impl.getResponse(null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)Response.ResponseType.REDIRECT, (Object)response.getResponseType());
        Assert.assertFalse((boolean)response.getUrl().contains("ticket="));
    }

    @Test
    public void testResponseWithNoTicketAndNoParameterInServiceURL() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "http://foo.com/");
        SimpleWebApplicationServiceImpl impl = SimpleWebApplicationServiceImpl.createServiceFrom((HttpServletRequest)request);
        Response response = impl.getResponse(null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)Response.ResponseType.REDIRECT, (Object)response.getResponseType());
        Assert.assertFalse((boolean)response.getUrl().contains("ticket="));
        Assert.assertEquals((Object)"http://foo.com/", (Object)response.getUrl());
    }

    @Test
    public void testResponseWithNoTicketAndOneParameterInServiceURL() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "http://foo.com/?param=test");
        SimpleWebApplicationServiceImpl impl = SimpleWebApplicationServiceImpl.createServiceFrom((HttpServletRequest)request);
        Response response = impl.getResponse(null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)Response.ResponseType.REDIRECT, (Object)response.getResponseType());
        Assert.assertEquals((Object)"http://foo.com/?param=test", (Object)response.getUrl());
    }
}

