/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.AbstractCentralAuthenticationServiceTest;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.web.bind.CredentialsBinder;
import org.jasig.cas.web.flow.AuthenticationViaFormAction;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.validation.BindException;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.test.MockRequestContext;

public class AuthenticationViaFormActionTests
extends AbstractCentralAuthenticationServiceTest {
    private AuthenticationViaFormAction action;
    private CookieGenerator warnCookieGenerator;

    @Before
    public void onSetUp() throws Exception {
        this.action = new AuthenticationViaFormAction();
        this.warnCookieGenerator = new CookieGenerator();
        this.warnCookieGenerator.setCookieName("WARN");
        this.warnCookieGenerator.setCookieName("TGT");
        this.warnCookieGenerator.setCookieDomain("/");
        this.warnCookieGenerator.setCookiePath("/");
        this.action.setCentralAuthenticationService(this.getCentralAuthenticationService());
        this.action.setWarnCookieGenerator(this.warnCookieGenerator);
    }

    @Test
    public void testSuccessfulAuthenticationWithNoService() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockRequestContext context = new MockRequestContext();
        request.addParameter("username", "test");
        request.addParameter("password", "test");
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        context.getRequestScope().put("credentials", (Object)TestUtils.getCredentialsWithSameUsernameAndPassword());
    }

    @Test
    public void testSuccessfulAuthenticationWithNoServiceAndWarn() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockRequestContext context = new MockRequestContext();
        request.addParameter("username", "test");
        request.addParameter("password", "test");
        request.addParameter("warn", "true");
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        context.getRequestScope().put("credentials", (Object)TestUtils.getCredentialsWithSameUsernameAndPassword());
    }

    @Test
    public void testSuccessfulAuthenticationWithServiceAndWarn() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockRequestContext context = new MockRequestContext();
        request.addParameter("username", "test");
        request.addParameter("password", "test");
        request.addParameter("warn", "true");
        request.addParameter("service", "test");
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        context.getRequestScope().put("credentials", (Object)TestUtils.getCredentialsWithSameUsernameAndPassword());
    }

    @Test
    public void testFailedAuthenticationWithNoService() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockRequestContext context = new MockRequestContext();
        request.addParameter("username", "test");
        request.addParameter("password", "test2");
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        context.getRequestScope().put("credentials", (Object)TestUtils.getCredentialsWithDifferentUsernameAndPassword());
        context.getRequestScope().put("org.springframework.validation.BindException.credentials", (Object)new BindException((Object)TestUtils.getCredentialsWithDifferentUsernameAndPassword(), "credentials"));
    }

    @Test
    public void testRenewWithServiceAndSameCredentials() throws Exception {
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockRequestContext context = new MockRequestContext();
        context.getFlowScope().put("ticketGrantingTicketId", (Object)ticketGrantingTicket);
        request.addParameter("renew", "true");
        request.addParameter("service", "test");
        request.addParameter("username", "test");
        request.addParameter("password", "test");
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        context.getFlowScope().put("service", (Object)TestUtils.getService("test"));
    }

    @Test
    public void testRenewWithServiceAndDifferentCredentials() throws Exception {
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockRequestContext context = new MockRequestContext();
        context.getFlowScope().put("ticketGrantingTicketId", (Object)ticketGrantingTicket);
        request.addParameter("renew", "true");
        request.addParameter("service", "test");
        request.addParameter("username", "test2");
        request.addParameter("password", "test2");
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
    }

    @Test
    public void testRenewWithServiceAndBadCredentials() throws Exception {
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockRequestContext context = new MockRequestContext();
        context.getFlowScope().put("ticketGrantingTicketId", (Object)ticketGrantingTicket);
        request.addParameter("renew", "true");
        request.addParameter("service", "test");
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        context.getRequestScope().put("credentials", (Object)TestUtils.getCredentialsWithDifferentUsernameAndPassword());
        context.getRequestScope().put("org.springframework.validation.BindException.credentials", (Object)new BindException((Object)TestUtils.getCredentialsWithDifferentUsernameAndPassword(), "credentials"));
    }

    @Test
    public void testTestBindingWithoutCredentialsBinder() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        request.addParameter("username", "test");
        request.addParameter("password", "test");
    }

    @Test
    public void testTestBindingWithCredentialsBinder() throws Exception {
        MockRequestContext context = new MockRequestContext();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse()));
        CredentialsBinder cb = new CredentialsBinder(){

            public void bind(HttpServletRequest request, Credential credentials) {
                ((UsernamePasswordCredential)credentials).setUsername("test2");
                ((UsernamePasswordCredential)credentials).setPassword("test2");
            }

            public boolean supports(Class<?> clazz) {
                return true;
            }
        };
        this.action.setCredentialsBinder(cb);
    }

    @Test
    public void testSetCredentialsBinderNoFailure() throws Exception {
        CredentialsBinder c = new CredentialsBinder(){

            public void bind(HttpServletRequest request, Credential credentials) {
            }

            public boolean supports(Class<?> clazz) {
                return true;
            }
        };
        this.action.setCredentialsBinder(c);
    }
}

