/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.springframework.util.Assert;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;

public final class WebUtils {
    public static final String CAS_ACCESS_DENIED_REASON = "CAS_ACCESS_DENIED_REASON";

    private WebUtils() {
    }

    public static HttpServletRequest getHttpServletRequest(RequestContext context) {
        Assert.isInstanceOf(ServletExternalContext.class, (Object)context.getExternalContext(), (String)("Cannot obtain HttpServletRequest from event of type: " + context.getExternalContext().getClass().getName()));
        return (HttpServletRequest)context.getExternalContext().getNativeRequest();
    }

    public static HttpServletResponse getHttpServletResponse(RequestContext context) {
        Assert.isInstanceOf(ServletExternalContext.class, (Object)context.getExternalContext(), (String)("Cannot obtain HttpServletResponse from event of type: " + context.getExternalContext().getClass().getName()));
        return (HttpServletResponse)context.getExternalContext().getNativeResponse();
    }

    public static WebApplicationService getService(List<ArgumentExtractor> argumentExtractors, HttpServletRequest request) {
        for (ArgumentExtractor argumentExtractor : argumentExtractors) {
            WebApplicationService service = argumentExtractor.extractService(request);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public static WebApplicationService getService(List<ArgumentExtractor> argumentExtractors, RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest(context);
        return WebUtils.getService(argumentExtractors, request);
    }

    public static WebApplicationService getService(RequestContext context) {
        return (WebApplicationService)context.getFlowScope().get("service");
    }

    public static void putTicketGrantingTicketInRequestScope(RequestContext context, String ticketValue) {
        context.getRequestScope().put("ticketGrantingTicketId", (Object)ticketValue);
    }

    public static void putTicketGrantingTicketInFlowScope(RequestContext context, String ticketValue) {
        context.getFlowScope().put("ticketGrantingTicketId", (Object)ticketValue);
    }

    public static String getTicketGrantingTicketId(RequestContext context) {
        String tgtFromRequest = (String)context.getRequestScope().get("ticketGrantingTicketId");
        String tgtFromFlow = (String)context.getFlowScope().get("ticketGrantingTicketId");
        return tgtFromRequest != null ? tgtFromRequest : tgtFromFlow;
    }

    public static void putServiceTicketInRequestScope(RequestContext context, String ticketValue) {
        context.getRequestScope().put("serviceTicketId", (Object)ticketValue);
    }

    public static String getServiceTicketFromRequestScope(RequestContext context) {
        return context.getRequestScope().getString("serviceTicketId");
    }

    public static void putLoginTicket(RequestContext context, String ticket) {
        context.getFlowScope().put("loginTicket", (Object)ticket);
    }

    public static String getLoginTicketFromFlowScope(RequestContext context) {
        String lt = (String)context.getFlowScope().remove("loginTicket");
        return lt != null ? lt : "";
    }

    public static String getLoginTicketFromRequest(RequestContext context) {
        return context.getRequestParameters().get("lt");
    }

    public static void putLogoutRequests(RequestContext context, List<LogoutRequest> requests) {
        context.getFlowScope().put("logoutRequests", requests);
    }

    public static List<LogoutRequest> getLogoutRequests(RequestContext context) {
        return (List)context.getFlowScope().get("logoutRequests");
    }
}

