/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public class JaasAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_REALM = "CAS";
    @NotNull
    private String realm = "CAS";

    public JaasAuthenticationHandler() {
        Assert.notNull((Object)Configuration.getConfiguration(), (String)"Static Configuration cannot be null. Did you remember to specify \"java.security.auth.login.config\"?");
    }

    @Override
    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        String username = credential.getUsername();
        LoginContext lc = new LoginContext(this.realm, new UsernamePasswordCallbackHandler(username, credential.getPassword()));
        try {
            this.logger.debug("Attempting authentication for: {}", (Object)username);
            lc.login();
        }
        finally {
            lc.logout();
        }
        SimplePrincipal principal = null;
        Set<Principal> principals = lc.getSubject().getPrincipals();
        if (principals != null && principals.size() > 0) {
            principal = new SimplePrincipal(principals.iterator().next().getName());
        }
        return this.createHandlerResult(credential, principal, null);
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    protected static final class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final String password;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        protected UsernamePasswordCallbackHandler(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            Callback[] callbackArray = callbacks;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)callbackArray);
            UsernamePasswordCallbackHandler.handle_aroundBody1$advice(this, callbackArray, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        static {
            UsernamePasswordCallbackHandler.ajc$preClinit();
        }

        private static final /* synthetic */ void handle_aroundBody0(UsernamePasswordCallbackHandler ajc$this, Callback[] callbacks, JoinPoint joinPoint) {
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                if (callback.getClass().equals(NameCallback.class)) {
                    ((NameCallback)callback).setName(ajc$this.userName);
                } else if (callback.getClass().equals(PasswordCallback.class)) {
                    ((PasswordCallback)callback).setPassword(ajc$this.password.toCharArray());
                } else {
                    throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
                }
                ++n2;
            }
        }

        private static final /* synthetic */ Object handle_aroundBody1$advice(UsernamePasswordCallbackHandler ajc$this, Callback[] callbacks, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            Object object;
            Object returnVal = null;
            Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (logger.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                UsernamePasswordCallbackHandler.handle_aroundBody0(ajc$this, callbacks, (JoinPoint)proceedingJoinPoint2);
                object = returnVal = null;
                logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            }
            catch (Throwable throwable) {
                logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
                throw throwable;
            }
            return object;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("JaasAuthenticationHandler.java", UsernamePasswordCallbackHandler.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handle", "org.jasig.cas.authentication.handler.support.JaasAuthenticationHandler$UsernamePasswordCallbackHandler", "[Ljavax.security.auth.callback.Callback;", "callbacks", "javax.security.auth.callback.UnsupportedCallbackException", "void"), 147);
        }
    }
}

