/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import java.util.Arrays;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.TicketState;
import org.slf4j.Logger;
import org.springframework.util.Assert;

@MappedSuperclass
public abstract class AbstractTicket
implements Ticket,
TicketState {
    private static final long serialVersionUID = -8506442397878267555L;
    @Lob
    @Column(name="EXPIRATION_POLICY", nullable=false)
    private ExpirationPolicy expirationPolicy;
    @Id
    @Column(name="ID", nullable=false)
    private String id;
    @ManyToOne(targetEntity=TicketGrantingTicketImpl.class)
    private TicketGrantingTicket ticketGrantingTicket;
    @Column(name="LAST_TIME_USED")
    private long lastTimeUsed;
    @Column(name="PREVIOUS_LAST_TIME_USED")
    private long previousLastTimeUsed;
    @Column(name="CREATION_TIME")
    private long creationTime;
    @Column(name="NUMBER_OF_TIMES_USED")
    private int countOfUses;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    protected AbstractTicket() {
    }

    public AbstractTicket(String id, TicketGrantingTicket ticket, ExpirationPolicy expirationPolicy) {
        Assert.notNull((Object)expirationPolicy, (String)"expirationPolicy cannot be null");
        Assert.notNull((Object)id, (String)"id cannot be null");
        this.id = id;
        this.creationTime = System.currentTimeMillis();
        this.lastTimeUsed = System.currentTimeMillis();
        this.expirationPolicy = expirationPolicy;
        this.ticketGrantingTicket = ticket;
    }

    @Override
    public final String getId() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        return (String)AbstractTicket.getId_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    protected final void updateState() {
        this.previousLastTimeUsed = this.lastTimeUsed;
        this.lastTimeUsed = System.currentTimeMillis();
        ++this.countOfUses;
    }

    @Override
    public final int getCountOfUses() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        return Conversions.intValue((Object)AbstractTicket.getCountOfUses_aroundBody3$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @Override
    public final long getCreationTime() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        return Conversions.longValue((Object)AbstractTicket.getCreationTime_aroundBody5$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @Override
    public final TicketGrantingTicket getGrantingTicket() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        return (TicketGrantingTicket)AbstractTicket.getGrantingTicket_aroundBody7$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public final long getLastTimeUsed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        return Conversions.longValue((Object)AbstractTicket.getLastTimeUsed_aroundBody9$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @Override
    public final long getPreviousTimeUsed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        return Conversions.longValue((Object)AbstractTicket.getPreviousTimeUsed_aroundBody11$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @Override
    public final boolean isExpired() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        return Conversions.booleanValue((Object)AbstractTicket.isExpired_aroundBody13$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    protected boolean isExpiredInternal() {
        return false;
    }

    public final int hashCode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        return Conversions.intValue((Object)AbstractTicket.hashCode_aroundBody15$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    public final String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        return (String)AbstractTicket.toString_aroundBody17$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    static {
        AbstractTicket.ajc$preClinit();
    }

    private static final /* synthetic */ Object getId_aroundBody1$advice(AbstractTicket ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = ajc$this.id;
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return string;
    }

    private static final /* synthetic */ Object getCountOfUses_aroundBody3$advice(AbstractTicket ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.intObject((int)ajc$this.countOfUses);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ Object getCreationTime_aroundBody5$advice(AbstractTicket ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.longObject((long)ajc$this.creationTime);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ Object getGrantingTicket_aroundBody7$advice(AbstractTicket ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        TicketGrantingTicket ticketGrantingTicket;
        TicketGrantingTicket returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            ticketGrantingTicket = returnVal = ajc$this.ticketGrantingTicket;
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return ticketGrantingTicket;
    }

    private static final /* synthetic */ Object getLastTimeUsed_aroundBody9$advice(AbstractTicket ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.longObject((long)ajc$this.lastTimeUsed);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ Object getPreviousTimeUsed_aroundBody11$advice(AbstractTicket ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.longObject((long)ajc$this.previousLastTimeUsed);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ boolean isExpired_aroundBody12(AbstractTicket ajc$this, JoinPoint joinPoint) {
        return ajc$this.expirationPolicy.isExpired(ajc$this) || ajc$this.getGrantingTicket() != null && ajc$this.getGrantingTicket().isExpired() || ajc$this.isExpiredInternal();
    }

    private static final /* synthetic */ Object isExpired_aroundBody13$advice(AbstractTicket ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)AbstractTicket.isExpired_aroundBody12(ajc$this, (JoinPoint)proceedingJoinPoint2));
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ int hashCode_aroundBody14(AbstractTicket ajc$this, JoinPoint joinPoint) {
        return ajc$this.getId().hashCode();
    }

    private static final /* synthetic */ Object hashCode_aroundBody15$advice(AbstractTicket ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.intObject((int)AbstractTicket.hashCode_aroundBody14(ajc$this, (JoinPoint)proceedingJoinPoint2));
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ Object toString_aroundBody17$advice(AbstractTicket ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = ajc$this.getId();
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return string;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractTicket.java", AbstractTicket.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getId", "org.jasig.cas.ticket.AbstractTicket", "", "", "", "java.lang.String"), 105);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getCountOfUses", "org.jasig.cas.ticket.AbstractTicket", "", "", "", "int"), 125);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getCreationTime", "org.jasig.cas.ticket.AbstractTicket", "", "", "", "long"), 129);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getGrantingTicket", "org.jasig.cas.ticket.AbstractTicket", "", "", "", "org.jasig.cas.ticket.TicketGrantingTicket"), 133);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getLastTimeUsed", "org.jasig.cas.ticket.AbstractTicket", "", "", "", "long"), 137);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getPreviousTimeUsed", "org.jasig.cas.ticket.AbstractTicket", "", "", "", "long"), 141);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "isExpired", "org.jasig.cas.ticket.AbstractTicket", "", "", "", "boolean"), 145);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "hashCode", "org.jasig.cas.ticket.AbstractTicket", "", "", "", "int"), 155);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "toString", "org.jasig.cas.ticket.AbstractTicket", "", "", "", "java.lang.String"), 159);
    }
}

