/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.AccountNotFoundException;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.Message;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.NoOpPrincipalNameTransformer;
import org.jasig.cas.authentication.handler.PasswordEncoder;
import org.jasig.cas.authentication.handler.PlainTextPasswordEncoder;
import org.jasig.cas.authentication.handler.PrincipalNameTransformer;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.support.PasswordPolicyConfiguration;
import org.slf4j.Logger;

public abstract class AbstractUsernamePasswordAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @NotNull
    private PasswordEncoder passwordEncoder = new PlainTextPasswordEncoder();
    @NotNull
    private PrincipalNameTransformer principalNameTransformer = new NoOpPrincipalNameTransformer();
    private PasswordPolicyConfiguration passwordPolicyConfiguration;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    protected final HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        UsernamePasswordCredential userPass = (UsernamePasswordCredential)credential;
        if (userPass.getUsername() == null) {
            throw new AccountNotFoundException("Username is null.");
        }
        String transformedUsername = this.principalNameTransformer.transform(userPass.getUsername());
        if (transformedUsername == null) {
            throw new AccountNotFoundException("Transformed username is null.");
        }
        userPass.setUsername(transformedUsername);
        return this.authenticateUsernamePasswordInternal(userPass);
    }

    protected abstract HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential var1) throws GeneralSecurityException, PreventedException;

    protected final PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    protected final PrincipalNameTransformer getPrincipalNameTransformer() {
        return this.principalNameTransformer;
    }

    protected final PasswordPolicyConfiguration getPasswordPolicyConfiguration() {
        return this.passwordPolicyConfiguration;
    }

    protected final HandlerResult createHandlerResult(Credential credential, Principal principal, List<Message> warnings) {
        return new HandlerResult(this, new BasicCredentialMetaData(credential), principal, warnings);
    }

    public final void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public final void setPrincipalNameTransformer(PrincipalNameTransformer principalNameTransformer) {
        this.principalNameTransformer = principalNameTransformer;
    }

    public final void setPasswordPolicyConfiguration(PasswordPolicyConfiguration passwordPolicyConfiguration) {
        this.passwordPolicyConfiguration = passwordPolicyConfiguration;
    }

    @Override
    public boolean supports(Credential credential) {
        Credential credential2 = credential;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)credential2);
        return Conversions.booleanValue((Object)AbstractUsernamePasswordAuthenticationHandler.supports_aroundBody1$advice(this, credential2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    static {
        AbstractUsernamePasswordAuthenticationHandler.ajc$preClinit();
    }

    private static final /* synthetic */ boolean supports_aroundBody0(AbstractUsernamePasswordAuthenticationHandler ajc$this, Credential credential, JoinPoint joinPoint) {
        return credential instanceof UsernamePasswordCredential;
    }

    private static final /* synthetic */ Object supports_aroundBody1$advice(AbstractUsernamePasswordAuthenticationHandler ajc$this, Credential credential, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)AbstractUsernamePasswordAuthenticationHandler.supports_aroundBody0(ajc$this, credential, (JoinPoint)proceedingJoinPoint2));
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractUsernamePasswordAuthenticationHandler.java", AbstractUsernamePasswordAuthenticationHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supports", "org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler", "org.jasig.cas.authentication.Credential", "credential", "", "boolean"), 150);
    }
}

