/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.monitor.CacheStatistics;
import org.jasig.cas.monitor.Status;
import org.jasig.cas.monitor.StatusCode;
import org.slf4j.Logger;

public class CacheStatus
extends Status {
    private final CacheStatistics[] statistics;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public CacheStatus(StatusCode code, String description, CacheStatistics ... statistics) {
        super(code, CacheStatus.buildDescription(description, statistics));
        this.statistics = statistics;
    }

    public CacheStatus(Exception e) {
        super(StatusCode.ERROR, String.format("Error fetching cache status: %s::%s", e.getClass().getSimpleName(), e.getMessage()));
        this.statistics = null;
    }

    public CacheStatistics[] getStatistics() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        return (CacheStatistics[])CacheStatus.getStatistics_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private static String buildDescription(String desc, CacheStatistics ... statistics) {
        if (statistics == null || statistics.length == 0) {
            return desc;
        }
        StringBuilder sb = new StringBuilder();
        if (desc != null) {
            sb.append(desc);
            if (!desc.endsWith(".")) {
                sb.append('.');
            }
            sb.append(' ');
        }
        sb.append("Cache statistics: [");
        int i = 0;
        CacheStatistics[] cacheStatisticsArray = statistics;
        int n = statistics.length;
        int n2 = 0;
        while (n2 < n) {
            CacheStatistics stats = cacheStatisticsArray[n2];
            if (i++ > 0) {
                sb.append('|');
            }
            stats.toString(sb);
            ++n2;
        }
        sb.append(']');
        return sb.toString();
    }

    static {
        CacheStatus.ajc$preClinit();
    }

    private static final /* synthetic */ Object getStatistics_aroundBody1$advice(CacheStatus ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        CacheStatistics[] cacheStatisticsArray;
        CacheStatistics[] returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            cacheStatisticsArray = returnVal = ajc$this.statistics;
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return cacheStatisticsArray;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CacheStatus.java", CacheStatus.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getStatistics", "org.jasig.cas.monitor.CacheStatus", "", "", "", "[Lorg.jasig.cas.monitor.CacheStatistics;"), 62);
    }
}

