/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.functors.TruePredicate;
import org.hamcrest.Matcher;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.CentralAuthenticationServiceImpl;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.jasig.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.jasig.cas.services.RefuseRegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceProxyPolicy;
import org.jasig.cas.services.ReturnAllAttributeReleasePolicy;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.jasig.cas.validation.Assertion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;

public class CentralAuthenticationServiceImplWithMockitoTests {
    private static final String TGT_ID = "tgt-id";
    private static final String TGT2_ID = "tgt2-id";
    private static final String ST_ID = "st-id";
    private static final String ST2_ID = "st2-id";
    private static final String SVC1_ID = "test1";
    private static final String SVC2_ID = "test2";
    private static final String PRINCIPAL = "principal";
    private CentralAuthenticationService cas;
    private Authentication authentication;
    private TicketRegistry ticketRegMock;

    @Before
    public void prepareNewCAS() {
        this.authentication = (Authentication)Mockito.mock(Authentication.class);
        Mockito.when((Object)this.authentication.getAuthenticationDate()).thenReturn((Object)new Date());
        BasicCredentialMetaData metadata = new BasicCredentialMetaData((Credential)TestUtils.getCredentialsWithSameUsernameAndPassword(PRINCIPAL));
        HashMap<String, DefaultHandlerResult> successes = new HashMap<String, DefaultHandlerResult>();
        successes.put("handler1", new DefaultHandlerResult((AuthenticationHandler)Mockito.mock(AuthenticationHandler.class), (CredentialMetaData)metadata));
        Mockito.when((Object)this.authentication.getCredentials()).thenReturn(Arrays.asList(metadata));
        Mockito.when((Object)this.authentication.getSuccesses()).thenReturn(successes);
        Mockito.when((Object)this.authentication.getPrincipal()).thenReturn((Object)new DefaultPrincipalFactory().createPrincipal(PRINCIPAL));
        Service service1 = TestUtils.getService(SVC1_ID);
        ServiceTicket stMock = this.createMockServiceTicket(ST_ID, service1);
        TicketGrantingTicket tgtRootMock = this.createRootTicketGrantingTicket();
        TicketGrantingTicket tgtMock = this.createMockTicketGrantingTicket(TGT_ID, stMock, false, tgtRootMock, new ArrayList<Authentication>());
        Mockito.when((Object)tgtMock.getProxiedBy()).thenReturn((Object)TestUtils.getService("proxiedBy"));
        List authnListMock = (List)Mockito.mock(List.class);
        Mockito.when((Object)authnListMock.size()).thenReturn((Object)2);
        Mockito.when(authnListMock.get(Mockito.anyInt())).thenReturn((Object)this.authentication);
        Mockito.when((Object)tgtMock.getChainedAuthentications()).thenReturn((Object)authnListMock);
        Mockito.when((Object)stMock.getGrantingTicket()).thenReturn((Object)tgtMock);
        Service service2 = TestUtils.getService(SVC2_ID);
        ServiceTicket stMock2 = this.createMockServiceTicket(ST2_ID, service2);
        TicketGrantingTicket tgtMock2 = this.createMockTicketGrantingTicket(TGT2_ID, stMock2, false, tgtRootMock, authnListMock);
        this.ticketRegMock = (TicketRegistry)Mockito.mock(TicketRegistry.class);
        Mockito.when((Object)this.ticketRegMock.getTicket((String)Mockito.eq((Object)tgtMock.getId()), (Class)Mockito.eq(TicketGrantingTicket.class))).thenReturn((Object)tgtMock);
        Mockito.when((Object)this.ticketRegMock.getTicket((String)Mockito.eq((Object)tgtMock2.getId()), (Class)Mockito.eq(TicketGrantingTicket.class))).thenReturn((Object)tgtMock2);
        Mockito.when((Object)this.ticketRegMock.getTicket((String)Mockito.eq((Object)stMock.getId()), (Class)Mockito.eq(ServiceTicket.class))).thenReturn((Object)stMock);
        Mockito.when((Object)this.ticketRegMock.getTicket((String)Mockito.eq((Object)stMock2.getId()), (Class)Mockito.eq(ServiceTicket.class))).thenReturn((Object)stMock2);
        Mockito.when((Object)this.ticketRegMock.getTickets()).thenReturn(Arrays.asList(tgtMock, tgtMock2, stMock, stMock2));
        RegisteredService mockRegSvc1 = this.createMockRegisteredService(service1.getId(), true, this.getServiceProxyPolicy(false));
        RegisteredService mockRegSvc2 = this.createMockRegisteredService("test", false, this.getServiceProxyPolicy(true));
        RegisteredService mockRegSvc3 = this.createMockRegisteredService(service2.getId(), true, this.getServiceProxyPolicy(true));
        ServicesManager smMock = (ServicesManager)Mockito.mock(ServicesManager.class);
        Mockito.when((Object)smMock.findServiceBy((Service)Mockito.argThat((Matcher)new VerifyServiceByIdMatcher(service1.getId())))).thenReturn((Object)mockRegSvc1);
        Mockito.when((Object)smMock.findServiceBy((Service)Mockito.argThat((Matcher)new VerifyServiceByIdMatcher("test")))).thenReturn((Object)mockRegSvc2);
        Mockito.when((Object)smMock.findServiceBy((Service)Mockito.argThat((Matcher)new VerifyServiceByIdMatcher(service2.getId())))).thenReturn((Object)mockRegSvc3);
        Map ticketIdGenForServiceMock = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)ticketIdGenForServiceMock.containsKey(Mockito.any())).thenReturn((Object)true);
        Mockito.when(ticketIdGenForServiceMock.get(Mockito.any())).thenReturn((Object)new DefaultUniqueTicketIdGenerator());
        this.cas = new CentralAuthenticationServiceImpl(this.ticketRegMock, (AuthenticationManager)Mockito.mock(AuthenticationManager.class), (UniqueTicketIdGenerator)Mockito.mock(UniqueTicketIdGenerator.class), ticketIdGenForServiceMock, (ExpirationPolicy)Mockito.mock(ExpirationPolicy.class), (ExpirationPolicy)Mockito.mock(ExpirationPolicy.class), smMock, (LogoutManager)Mockito.mock(LogoutManager.class));
    }

    @Test(expected=InvalidTicketException.class)
    public void verifyNonExistentServiceWhenDelegatingTicketGrantingTicket() throws Exception {
        this.cas.delegateTicketGrantingTicket("bad-st", new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
    }

    @Test(expected=UnauthorizedServiceException.class)
    public void verifyInvalidServiceWhenDelegatingTicketGrantingTicket() throws Exception {
        this.cas.delegateTicketGrantingTicket(ST_ID, new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
    }

    @Test(expected=UnauthorizedProxyingException.class)
    public void disallowVendingServiceTicketsWhenServiceIsNotAllowedToProxyCAS1019() throws TicketException {
        this.cas.grantServiceTicket(TGT_ID, TestUtils.getService(SVC1_ID));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTicketGrantingTicketIfTicketIdIsNull() throws InvalidTicketException {
        this.cas.getTicket(null, TicketGrantingTicket.class);
    }

    @Test(expected=InvalidTicketException.class)
    public void getTicketGrantingTicketIfTicketIdIsMissing() throws InvalidTicketException {
        this.cas.getTicket("TGT-9000", TicketGrantingTicket.class);
    }

    @Test
    public void getTicketsWithNoPredicate() {
        Collection c = this.cas.getTickets(TruePredicate.INSTANCE);
        Assert.assertEquals((long)c.size(), (long)this.ticketRegMock.getTickets().size());
    }

    @Test
    public void verifyChainedAuthenticationsOnValidation() throws TicketException {
        Service svc = TestUtils.getService(SVC2_ID);
        ServiceTicket st = this.cas.grantServiceTicket(TGT2_ID, svc);
        Assert.assertNotNull((Object)st);
        Assertion assertion = this.cas.validateServiceTicket(st.getId(), svc);
        Assert.assertNotNull((Object)assertion);
        Assert.assertEquals((Object)assertion.getService(), (Object)svc);
        Assert.assertEquals((Object)assertion.getPrimaryAuthentication().getPrincipal().getId(), (Object)PRINCIPAL);
        Assert.assertTrue((assertion.getChainedAuthentications().size() == 2 ? 1 : 0) != 0);
        for (int i = 0; i < assertion.getChainedAuthentications().size(); ++i) {
            Authentication auth = (Authentication)assertion.getChainedAuthentications().get(i);
            Assert.assertEquals((Object)auth, (Object)this.authentication);
        }
    }

    private TicketGrantingTicket createRootTicketGrantingTicket() {
        TicketGrantingTicket tgtRootMock = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)tgtRootMock.isExpired()).thenReturn((Object)false);
        Mockito.when((Object)tgtRootMock.getAuthentication()).thenReturn((Object)this.authentication);
        return tgtRootMock;
    }

    private TicketGrantingTicket createMockTicketGrantingTicket(String id, ServiceTicket svcTicket, boolean isExpired, TicketGrantingTicket root, List<Authentication> chainedAuthnList) {
        TicketGrantingTicket tgtMock = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)tgtMock.isExpired()).thenReturn((Object)isExpired);
        Mockito.when((Object)tgtMock.getId()).thenReturn((Object)id);
        String svcId = svcTicket.getService().getId();
        Mockito.when((Object)tgtMock.grantServiceTicket(Mockito.anyString(), (Service)Mockito.argThat((Matcher)new VerifyServiceByIdMatcher(svcId)), (ExpirationPolicy)Mockito.any(ExpirationPolicy.class), Mockito.anyBoolean())).thenReturn((Object)svcTicket);
        Mockito.when((Object)tgtMock.getRoot()).thenReturn((Object)root);
        Mockito.when((Object)tgtMock.getChainedAuthentications()).thenReturn(chainedAuthnList);
        Mockito.when((Object)svcTicket.getGrantingTicket()).thenReturn((Object)tgtMock);
        return tgtMock;
    }

    private ServiceTicket createMockServiceTicket(String id, Service svc) {
        ServiceTicket stMock = (ServiceTicket)Mockito.mock(ServiceTicket.class);
        Mockito.when((Object)stMock.getService()).thenReturn((Object)svc);
        Mockito.when((Object)stMock.getId()).thenReturn((Object)id);
        Mockito.when((Object)stMock.isValidFor(svc)).thenReturn((Object)true);
        return stMock;
    }

    private RegisteredServiceProxyPolicy getServiceProxyPolicy(boolean canProxy) {
        if (!canProxy) {
            return new RefuseRegisteredServiceProxyPolicy();
        }
        return new RegexMatchingRegisteredServiceProxyPolicy(".*");
    }

    private RegisteredService createMockRegisteredService(String svcId, boolean enabled, RegisteredServiceProxyPolicy proxy) {
        RegisteredService mockRegSvc = (RegisteredService)Mockito.mock(RegisteredService.class);
        Mockito.when((Object)mockRegSvc.getServiceId()).thenReturn((Object)svcId);
        Mockito.when((Object)mockRegSvc.getProxyPolicy()).thenReturn((Object)proxy);
        Mockito.when((Object)mockRegSvc.getName()).thenReturn((Object)svcId);
        Mockito.when((Object)mockRegSvc.matches((Service)Mockito.argThat((Matcher)new VerifyServiceByIdMatcher(svcId)))).thenReturn((Object)true);
        Mockito.when((Object)mockRegSvc.getAttributeReleasePolicy()).thenReturn((Object)new ReturnAllAttributeReleasePolicy());
        Mockito.when((Object)mockRegSvc.getUsernameAttributeProvider()).thenReturn((Object)new DefaultRegisteredServiceUsernameProvider());
        Mockito.when((Object)mockRegSvc.getAccessStrategy()).thenReturn((Object)new DefaultRegisteredServiceAccessStrategy(enabled, true));
        return mockRegSvc;
    }

    private static class VerifyServiceByIdMatcher
    extends ArgumentMatcher<Service> {
        private final String id;

        public VerifyServiceByIdMatcher(String id) {
            this.id = id;
        }

        public boolean matches(Object argument) {
            Service s = (Service)argument;
            return s != null && s.getId().equals(this.id);
        }
    }
}

