/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.MixedPrincipalException;
import org.jasig.cas.authentication.OneTimePasswordCredential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.jasig.cas.validation.Assertion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"/mfa-test-context.xml"})
public class MultifactorAuthenticationTests {
    @Autowired
    private CentralAuthenticationService cas;

    @Test
    public void verifyAllowsAccessToNormalSecurityServiceWithPassword() throws Exception {
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("alice", "alice")});
        Assert.assertNotNull((Object)tgt);
        ServiceTicket st = this.cas.grantServiceTicket(tgt.getId(), MultifactorAuthenticationTests.newService("https://example.com/normal/"));
        Assert.assertNotNull((Object)st);
    }

    @Test
    public void verifyAllowsAccessToNormalSecurityServiceWithOTP() throws Exception {
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(new Credential[]{new OneTimePasswordCredential("alice", "31415")});
        Assert.assertNotNull((Object)tgt);
        ServiceTicket st = this.cas.grantServiceTicket(tgt.getId(), MultifactorAuthenticationTests.newService("https://example.com/normal/"));
        Assert.assertNotNull((Object)st);
    }

    @Test(expected=UnsatisfiedAuthenticationPolicyException.class)
    public void verifyDeniesAccessToHighSecurityServiceWithPassword() throws Exception {
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("alice", "alice")});
        Assert.assertNotNull((Object)tgt);
        this.cas.grantServiceTicket(tgt.getId(), MultifactorAuthenticationTests.newService("https://example.com/high/"));
    }

    @Test(expected=UnsatisfiedAuthenticationPolicyException.class)
    public void verifyDeniesAccessToHighSecurityServiceWithOTP() throws Exception {
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(new Credential[]{new OneTimePasswordCredential("alice", "31415")});
        Assert.assertNotNull((Object)tgt);
        ServiceTicket st = this.cas.grantServiceTicket(tgt.getId(), MultifactorAuthenticationTests.newService("https://example.com/high/"));
        Assert.assertNotNull((Object)st);
    }

    @Test
    public void verifyAllowsAccessToHighSecurityServiceWithPasswordAndOTP() throws Exception {
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("alice", "alice"), new OneTimePasswordCredential("alice", "31415")});
        Assert.assertNotNull((Object)tgt);
        ServiceTicket st = this.cas.grantServiceTicket(tgt.getId(), MultifactorAuthenticationTests.newService("https://example.com/high/"));
        Assert.assertNotNull((Object)st);
    }

    @Test
    public void verifyAllowsAccessToHighSecurityServiceWithPasswordAndOTPViaRenew() throws Exception {
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("alice", "alice")});
        Assert.assertNotNull((Object)tgt);
        Service service = MultifactorAuthenticationTests.newService("https://example.com/high/");
        ServiceTicket st = this.cas.grantServiceTicket(tgt.getId(), service, new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("alice", "alice"), new OneTimePasswordCredential("alice", "31415")});
        Assert.assertNotNull((Object)st);
        Assertion assertion = this.cas.validateServiceTicket(st.getId(), service);
        Assert.assertEquals((long)2L, (long)assertion.getPrimaryAuthentication().getSuccesses().size());
        Assert.assertTrue((boolean)assertion.getPrimaryAuthentication().getSuccesses().containsKey("passwordHandler"));
        Assert.assertTrue((boolean)assertion.getPrimaryAuthentication().getSuccesses().containsKey("oneTimePasswordHandler"));
        Assert.assertTrue((boolean)assertion.getPrimaryAuthentication().getAttributes().containsKey("successfulAuthenticationHandlers"));
    }

    @Test(expected=MixedPrincipalException.class)
    public void verifyThrowsMixedPrincipalExceptionOnRenewWithDifferentPrincipal() throws Exception {
        TicketGrantingTicket tgt = this.cas.createTicketGrantingTicket(new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("alice", "alice")});
        Assert.assertNotNull((Object)tgt);
        Service service = MultifactorAuthenticationTests.newService("https://example.com/high/");
        this.cas.grantServiceTicket(tgt.getId(), service, new Credential[]{MultifactorAuthenticationTests.newUserPassCredentials("bob", "bob"), new OneTimePasswordCredential("bob", "62831")});
    }

    private static UsernamePasswordCredential newUserPassCredentials(String user, String pass) {
        UsernamePasswordCredential userpass = new UsernamePasswordCredential();
        userpass.setUsername(user);
        userpass.setPassword(pass);
        return userpass;
    }

    private static Service newService(String id) {
        return new SimpleWebApplicationServiceImpl(id);
    }
}

