/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.AcceptUsersAuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.services.RegisteredService;
import org.junit.Assert;
import org.junit.Test;

public class AcceptUsersAuthenticationHandlerTests {
    private final Map<String, String> users = new HashMap<String, String>();
    private final AcceptUsersAuthenticationHandler authenticationHandler;

    public AcceptUsersAuthenticationHandlerTests() throws Exception {
        this.users.put("scott", "rutgers");
        this.users.put("dima", "javarules");
        this.users.put("bill", "thisisAwesoME");
        this.users.put("brian", "t\ufffdst");
        this.authenticationHandler = new AcceptUsersAuthenticationHandler();
        this.authenticationHandler.setUsers(this.users);
    }

    @Test
    public void verifySupportsSpecialCharacters() throws Exception {
        UsernamePasswordCredential c = new UsernamePasswordCredential();
        c.setUsername("brian");
        c.setPassword("t\ufffdst");
        Assert.assertEquals((Object)"brian", (Object)this.authenticationHandler.authenticate((Credential)c).getPrincipal().getId());
    }

    @Test
    public void verifySupportsProperUserCredentials() throws Exception {
        UsernamePasswordCredential c = new UsernamePasswordCredential();
        c.setUsername("scott");
        c.setPassword("rutgers");
        Assert.assertTrue((boolean)this.authenticationHandler.supports((Credential)c));
    }

    @Test
    public void verifyDoesntSupportBadUserCredentials() {
        try {
            Assert.assertFalse((boolean)this.authenticationHandler.supports((Credential)new HttpBasedServiceCredential(new URL("http://www.rutgers.edu"), (RegisteredService)TestUtils.getRegisteredService("https://some.app.edu"))));
        }
        catch (MalformedURLException e) {
            Assert.fail((String)"Could not resolve URL.");
        }
    }

    @Test
    public void verifyAuthenticatesUserInMap() throws Exception {
        UsernamePasswordCredential c = new UsernamePasswordCredential();
        c.setUsername("scott");
        c.setPassword("rutgers");
        try {
            Assert.assertEquals((Object)"scott", (Object)this.authenticationHandler.authenticate((Credential)c).getPrincipal().getId());
        }
        catch (GeneralSecurityException e) {
            Assert.fail((String)"AuthenticationException caught but it should not have been thrown.");
        }
    }

    @Test(expected=AccountNotFoundException.class)
    public void verifyFailsUserNotInMap() throws Exception {
        UsernamePasswordCredential c = new UsernamePasswordCredential();
        c.setUsername("fds");
        c.setPassword("rutgers");
        this.authenticationHandler.authenticate((Credential)c);
    }

    @Test(expected=AccountNotFoundException.class)
    public void verifyFailsNullUserName() throws Exception {
        UsernamePasswordCredential c = new UsernamePasswordCredential();
        c.setUsername(null);
        c.setPassword("user");
        this.authenticationHandler.authenticate((Credential)c);
    }

    @Test(expected=AccountNotFoundException.class)
    public void verifyFailsNullUserNameAndPassword() throws Exception {
        UsernamePasswordCredential c = new UsernamePasswordCredential();
        c.setUsername(null);
        c.setPassword(null);
        this.authenticationHandler.authenticate((Credential)c);
    }

    @Test(expected=FailedLoginException.class)
    public void verifyFailsNullPassword() throws Exception {
        UsernamePasswordCredential c = new UsernamePasswordCredential();
        c.setUsername("scott");
        c.setPassword(null);
        this.authenticationHandler.authenticate((Credential)c);
    }
}

