/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.io.File;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.jasig.cas.authentication.FileTrustStoreSslSocketFactory;
import org.jasig.cas.util.http.SimpleHttpClient;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;

public class FileTrustStoreSslSocketFactoryTests {
    @Test
    public void verifyTrustStoreLoadingSuccessfullyWithCertAvailable() throws Exception {
        ClassPathResource resource = new ClassPathResource("truststore.jks");
        FileTrustStoreSslSocketFactory factory = new FileTrustStoreSslSocketFactory(resource.getFile(), "changeit");
        SimpleHttpClientFactoryBean clientFactory = new SimpleHttpClientFactoryBean();
        clientFactory.setSslSocketFactory((SSLConnectionSocketFactory)factory);
        SimpleHttpClient client = clientFactory.getObject();
        Assert.assertTrue((boolean)client.isValidEndPoint("https://www.cacert.org"));
    }

    @Test
    public void verifyTrustStoreLoadingSuccessfullyWithCertAvailable2() throws Exception {
        ClassPathResource resource = new ClassPathResource("truststore.jks");
        FileTrustStoreSslSocketFactory factory = new FileTrustStoreSslSocketFactory(resource.getFile(), "changeit");
        SimpleHttpClientFactoryBean clientFactory = new SimpleHttpClientFactoryBean();
        clientFactory.setSslSocketFactory((SSLConnectionSocketFactory)factory);
        SimpleHttpClient client = clientFactory.getObject();
        Assert.assertTrue((boolean)client.isValidEndPoint("https://test.scaldingspoon.org/idp/shibboleth"));
    }

    @Test(expected=RuntimeException.class)
    public void verifyTrustStoreNotFound() throws Exception {
        new FileTrustStoreSslSocketFactory(new File("test.jks"), "changeit");
    }

    @Test(expected=RuntimeException.class)
    public void verifyTrustStoreBadPassword() throws Exception {
        ClassPathResource resource = new ClassPathResource("truststore.jks");
        new FileTrustStoreSslSocketFactory(resource.getFile(), "invalid");
    }

    @Test
    public void verifyTrustStoreLoadingSuccessfullyForValidEndpointWithNoCert() throws Exception {
        ClassPathResource resource = new ClassPathResource("truststore.jks");
        FileTrustStoreSslSocketFactory factory = new FileTrustStoreSslSocketFactory(resource.getFile(), "changeit");
        SimpleHttpClientFactoryBean clientFactory = new SimpleHttpClientFactoryBean();
        clientFactory.setSslSocketFactory((SSLConnectionSocketFactory)factory);
        SimpleHttpClient client = clientFactory.getObject();
        Assert.assertTrue((boolean)client.isValidEndPoint("https://www.google.com"));
    }

    @Test
    public void verifyTrustStoreLoadingSuccessfullyWihInsecureEndpoint() throws Exception {
        ClassPathResource resource = new ClassPathResource("truststore.jks");
        FileTrustStoreSslSocketFactory factory = new FileTrustStoreSslSocketFactory(resource.getFile(), "changeit");
        SimpleHttpClientFactoryBean clientFactory = new SimpleHttpClientFactoryBean();
        clientFactory.setSslSocketFactory((SSLConnectionSocketFactory)factory);
        SimpleHttpClient client = clientFactory.getObject();
        Assert.assertTrue((boolean)client.isValidEndPoint("http://wikipedia.org"));
    }
}

