/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.login.FailedLoginException;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.ImmutableAuthentication;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableAuthenticationTests {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Test
    public void verifyImmutable() {
        SimpleTestUsernamePasswordAuthenticationHandler authenticationHandler = new SimpleTestUsernamePasswordAuthenticationHandler();
        BasicCredentialMetaData credential1 = new BasicCredentialMetaData((Credential)new UsernamePasswordCredential());
        BasicCredentialMetaData credential2 = new BasicCredentialMetaData((Credential)new UsernamePasswordCredential());
        ArrayList<BasicCredentialMetaData> credentials = new ArrayList<BasicCredentialMetaData>();
        credentials.add(credential1);
        credentials.add(credential2);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("authenticationMethod", "password");
        HashMap<String, DefaultHandlerResult> successes = new HashMap<String, DefaultHandlerResult>();
        successes.put("handler1", new DefaultHandlerResult((AuthenticationHandler)authenticationHandler, (CredentialMetaData)credential1));
        HashMap<String, Class<FailedLoginException>> failures = new HashMap<String, Class<FailedLoginException>>();
        failures.put("handler2", FailedLoginException.class);
        ImmutableAuthentication auth = new ImmutableAuthentication(new DateTime(), credentials, new DefaultPrincipalFactory().createPrincipal("test"), attributes, successes, failures);
        try {
            auth.getAuthenticationDate().setTime(100L);
            Assert.fail((String)"Should have failed");
        }
        catch (RuntimeException e) {
            this.logger.debug("Setting authenticate date/time failed correctly");
        }
        try {
            auth.getCredentials().add(new BasicCredentialMetaData((Credential)new UsernamePasswordCredential()));
            Assert.fail((String)"Should have failed");
        }
        catch (RuntimeException e) {
            this.logger.debug("Adding authentication credential metadata failed correctly");
        }
        try {
            auth.getSuccesses().put("test", new DefaultHandlerResult((AuthenticationHandler)authenticationHandler, (CredentialMetaData)credential1));
            Assert.fail((String)"Should have failed");
        }
        catch (RuntimeException e) {
            this.logger.debug("Adding authentication success event failed correctly");
        }
        try {
            auth.getFailures().put("test", FailedLoginException.class);
            Assert.fail((String)"Should have failed");
        }
        catch (RuntimeException e) {
            this.logger.debug("Adding authentication failure event failed correctly");
        }
    }
}

