/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import javax.security.auth.login.FailedLoginException;
import org.jasig.cas.authentication.AllAuthenticationPolicy;
import org.jasig.cas.authentication.AnyAuthenticationPolicy;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationPolicy;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.PolicyBasedAuthenticationManager;
import org.jasig.cas.authentication.RequiredHandlerAuthenticationPolicy;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PolicyBasedAuthenticationManagerTests {
    @Test
    public void verifyAuthenticateAnySuccess() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler(true), PolicyBasedAuthenticationManagerTests.newMockHandler(false)});
        Authentication auth = manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.assertEquals((long)1L, (long)auth.getSuccesses().size());
        Assert.assertEquals((long)0L, (long)auth.getFailures().size());
        Assert.assertEquals((long)2L, (long)auth.getCredentials().size());
    }

    @Test
    public void verifyAuthenticateAnyButTryAllSuccess() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler(true), PolicyBasedAuthenticationManagerTests.newMockHandler(false)});
        AnyAuthenticationPolicy any = new AnyAuthenticationPolicy();
        any.setTryAll(true);
        manager.setAuthenticationPolicy((AuthenticationPolicy)any);
        Authentication auth = manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.assertEquals((long)1L, (long)auth.getSuccesses().size());
        Assert.assertEquals((long)1L, (long)auth.getFailures().size());
        Assert.assertEquals((long)2L, (long)auth.getCredentials().size());
    }

    @Test(expected=AuthenticationException.class)
    public void verifyAuthenticateAnyFailure() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler(false), PolicyBasedAuthenticationManagerTests.newMockHandler(false)});
        manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.fail((String)"Should have thrown AuthenticationException");
    }

    @Test
    public void verifyAuthenticateAllSuccess() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler(true), PolicyBasedAuthenticationManagerTests.newMockHandler(true)});
        manager.setAuthenticationPolicy((AuthenticationPolicy)new AllAuthenticationPolicy());
        Authentication auth = manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.assertEquals((long)2L, (long)auth.getSuccesses().size());
        Assert.assertEquals((long)0L, (long)auth.getFailures().size());
        Assert.assertEquals((long)2L, (long)auth.getCredentials().size());
    }

    @Test(expected=AuthenticationException.class)
    public void verifyAuthenticateAllFailure() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler(false), PolicyBasedAuthenticationManagerTests.newMockHandler(false)});
        manager.setAuthenticationPolicy((AuthenticationPolicy)new AllAuthenticationPolicy());
        manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.fail((String)"Should have thrown AuthenticationException");
    }

    @Test
    public void verifyAuthenticateRequiredHandlerSuccess() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerA", true), PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerB", false)});
        manager.setAuthenticationPolicy((AuthenticationPolicy)new RequiredHandlerAuthenticationPolicy("HandlerA"));
        Authentication auth = manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.assertEquals((long)1L, (long)auth.getSuccesses().size());
        Assert.assertEquals((long)0L, (long)auth.getFailures().size());
        Assert.assertEquals((long)2L, (long)auth.getCredentials().size());
    }

    @Test(expected=AuthenticationException.class)
    public void verifyAuthenticateRequiredHandlerFailure() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerA", true), PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerB", false)});
        manager.setAuthenticationPolicy((AuthenticationPolicy)new RequiredHandlerAuthenticationPolicy("HandlerB"));
        manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.fail((String)"Should have thrown AuthenticationException");
    }

    @Test
    public void verifyAuthenticateRequiredHandlerTryAllSuccess() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerA", true), PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerB", false)});
        RequiredHandlerAuthenticationPolicy policy = new RequiredHandlerAuthenticationPolicy("HandlerA");
        policy.setTryAll(true);
        manager.setAuthenticationPolicy((AuthenticationPolicy)policy);
        Authentication auth = manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.assertEquals((long)1L, (long)auth.getSuccesses().size());
        Assert.assertEquals((long)1L, (long)auth.getFailures().size());
        Assert.assertEquals((long)2L, (long)auth.getCredentials().size());
    }

    private static AuthenticationHandler newMockHandler(boolean success) throws Exception {
        return PolicyBasedAuthenticationManagerTests.newMockHandler("MockAuthenticationHandler" + System.nanoTime(), success);
    }

    private static AuthenticationHandler newMockHandler(String name, boolean success) throws Exception {
        AuthenticationHandler mock = (AuthenticationHandler)Mockito.mock(AuthenticationHandler.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)name);
        Mockito.when((Object)mock.supports((Credential)Mockito.any(Credential.class))).thenReturn((Object)true);
        if (success) {
            Principal p = new DefaultPrincipalFactory().createPrincipal("nobody");
            DefaultHandlerResult result = new DefaultHandlerResult(mock, (CredentialMetaData)Mockito.mock(CredentialMetaData.class), p);
            Mockito.when((Object)mock.authenticate((Credential)Mockito.any(Credential.class))).thenReturn((Object)result);
        } else {
            Mockito.when((Object)mock.authenticate((Credential)Mockito.any(Credential.class))).thenThrow(new Throwable[]{new FailedLoginException()});
        }
        return mock;
    }
}

