/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import javax.security.auth.login.FailedLoginException;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class SimpleTestUsernamePasswordHandlerTests {
    private SimpleTestUsernamePasswordAuthenticationHandler authenticationHandler;

    @Before
    public void setUp() throws Exception {
        this.authenticationHandler = new SimpleTestUsernamePasswordAuthenticationHandler();
    }

    @Test
    public void verifySupportsProperUserCredentials() {
        Assert.assertTrue((boolean)this.authenticationHandler.supports((Credential)TestUtils.getCredentialsWithSameUsernameAndPassword()));
    }

    @Test
    public void verifyDoesntSupportBadUserCredentials() {
        Assert.assertFalse((boolean)this.authenticationHandler.supports((Credential)TestUtils.getHttpBasedServiceCredentials()));
    }

    @Test
    public void verifyValidUsernamePassword() throws Exception {
        HandlerResult result = this.authenticationHandler.authenticate((Credential)TestUtils.getCredentialsWithSameUsernameAndPassword());
        Assert.assertEquals((Object)"SimpleTestUsernamePasswordAuthenticationHandler", (Object)result.getHandlerName());
    }

    @Test(expected=FailedLoginException.class)
    public void verifyInvalidUsernamePassword() throws Exception {
        this.authenticationHandler.authenticate((Credential)TestUtils.getCredentialsWithDifferentUsernameAndPassword());
    }
}

