/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.ChainingPrincipalResolver;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;

public class ChainingPrincipalResolverTest {
    private final PrincipalFactory principalFactory = new DefaultPrincipalFactory();

    @Test
    public void examineSupports() throws Exception {
        Credential credential = (Credential)Mockito.mock(Credential.class);
        Mockito.when((Object)credential.getId()).thenReturn((Object)"a");
        PrincipalResolver resolver1 = (PrincipalResolver)Mockito.mock(PrincipalResolver.class);
        Mockito.when((Object)resolver1.supports((Credential)Mockito.eq((Object)credential))).thenReturn((Object)true);
        PrincipalResolver resolver2 = (PrincipalResolver)Mockito.mock(PrincipalResolver.class);
        Mockito.when((Object)resolver2.supports((Credential)Mockito.eq((Object)credential))).thenReturn((Object)false);
        ChainingPrincipalResolver resolver = new ChainingPrincipalResolver();
        resolver.setChain(Arrays.asList(resolver1, resolver2));
        Assert.assertTrue((boolean)resolver.supports(credential));
    }

    @Test
    public void examineResolve() throws Exception {
        Credential credential = (Credential)Mockito.mock(Credential.class);
        Mockito.when((Object)credential.getId()).thenReturn((Object)"input");
        PrincipalResolver resolver1 = (PrincipalResolver)Mockito.mock(PrincipalResolver.class);
        Mockito.when((Object)resolver1.supports((Credential)Mockito.eq((Object)credential))).thenReturn((Object)true);
        Mockito.when((Object)resolver1.resolve((Credential)Mockito.eq((Object)credential))).thenReturn((Object)this.principalFactory.createPrincipal("output"));
        PrincipalResolver resolver2 = (PrincipalResolver)Mockito.mock(PrincipalResolver.class);
        Mockito.when((Object)resolver2.supports((Credential)Mockito.any(Credential.class))).thenReturn((Object)false);
        Mockito.when((Object)resolver2.resolve((Credential)Mockito.argThat((Matcher)new ArgumentMatcher<Credential>(){

            public boolean matches(Object o) {
                return "output".equals(((Credential)o).getId());
            }
        }))).thenReturn((Object)this.principalFactory.createPrincipal("final", Collections.singletonMap("mail", "final@example.com")));
        ChainingPrincipalResolver resolver = new ChainingPrincipalResolver();
        resolver.setChain(Arrays.asList(resolver1, resolver2));
        Principal principal = resolver.resolve(credential);
        Assert.assertEquals((Object)"final", (Object)principal.getId());
        Assert.assertEquals((Object)"final@example.com", principal.getAttributes().get("mail"));
    }
}

