/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.principal.PersonDirectoryPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.junit.Assert;
import org.junit.Test;

public class PersonDirectoryPrincipalResolverTests {
    @Test
    public void verifyNullPrincipal() {
        PersonDirectoryPrincipalResolver resolver = new PersonDirectoryPrincipalResolver();
        Principal p = resolver.resolve(new Credential(){

            public String getId() {
                return null;
            }
        });
        Assert.assertNull((Object)p);
    }

    @Test
    public void verifyNullAttributes() {
        PersonDirectoryPrincipalResolver resolver = new PersonDirectoryPrincipalResolver();
        resolver.setReturnNullIfNoAttributes(true);
        resolver.setPrincipalAttributeName("test");
        UsernamePasswordCredential c = TestUtils.getCredentialsWithSameUsernameAndPassword();
        Principal p = resolver.resolve((Credential)c);
        Assert.assertNull((Object)p);
    }

    @Test
    public void verifyNoAttributesWithPrincipal() {
        PersonDirectoryPrincipalResolver resolver = new PersonDirectoryPrincipalResolver();
        resolver.setPrincipalAttributeName("test");
        UsernamePasswordCredential c = TestUtils.getCredentialsWithSameUsernameAndPassword();
        Principal p = resolver.resolve((Credential)c);
        Assert.assertNotNull((Object)p);
    }

    @Test
    public void verifyAttributesWithPrincipal() {
        PersonDirectoryPrincipalResolver resolver = new PersonDirectoryPrincipalResolver();
        resolver.setAttributeRepository(TestUtils.getAttributeRepository());
        resolver.setPrincipalAttributeName("cn");
        UsernamePasswordCredential c = TestUtils.getCredentialsWithSameUsernameAndPassword();
        Principal p = resolver.resolve((Credential)c);
        Assert.assertNotNull((Object)p);
        Assert.assertNotEquals((Object)p.getId(), (Object)"test");
        Assert.assertTrue((boolean)p.getAttributes().containsKey("memberOf"));
    }
}

