/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.support.DefaultCasAttributeEncoder;
import org.jasig.cas.services.ServicesManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"/core-context.xml", "/WEB-INF/cas-servlet.xml"})
public class DefaultCasAttributeEncoderTests {
    private Map<String, Object> attributes;
    @Autowired
    private ServicesManager servicesManager;

    @Before
    public void before() {
        this.attributes = new HashMap<String, Object>();
        for (int i = 0; i < 3; ++i) {
            this.attributes.put("attr" + i, this.newSingleAttribute("value" + i));
        }
        this.attributes.put("proxyGrantingTicket", this.newSingleAttribute("PGT-1234567"));
        this.attributes.put("credential", this.newSingleAttribute("PrincipalPassword"));
    }

    private Collection<String> newSingleAttribute(String attr) {
        return Collections.singleton(attr);
    }

    @Test
    public void checkNoPublicKeyDefined() {
        Service service = TestUtils.getService("testDefault");
        DefaultCasAttributeEncoder encoder = new DefaultCasAttributeEncoder(this.servicesManager);
        Map encoded = encoder.encodeAttributes(this.attributes, service);
        Assert.assertEquals((long)encoded.size(), (long)(this.attributes.size() - 2));
    }

    @Test
    public void checkAttributesEncodedCorrectly() {
        Service service = TestUtils.getService("testencryption");
        DefaultCasAttributeEncoder encoder = new DefaultCasAttributeEncoder(this.servicesManager);
        Map encoded = encoder.encodeAttributes(this.attributes, service);
        Assert.assertEquals((long)encoded.size(), (long)this.attributes.size());
        this.checkEncryptedValues("credential", encoded);
        this.checkEncryptedValues("proxyGrantingTicket", encoded);
    }

    private void checkEncryptedValues(String name, Map<String, Object> encoded) {
        String v1 = ((Collection)this.attributes.get(name)).iterator().next().toString();
        String v2 = (String)encoded.get(name);
        Assert.assertNotEquals((Object)v1, (Object)v2);
    }
}

