/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.mock;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultAuthenticationBuilder;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.mock.MockServiceTicket;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;

public class MockTicketGrantingTicket
implements TicketGrantingTicket {
    public static final UniqueTicketIdGenerator ID_GENERATOR = new DefaultUniqueTicketIdGenerator();
    private static final long serialVersionUID = 6546995681334670659L;
    private final String id;
    private final Authentication authentication;
    private final Date created;
    private int usageCount;
    private boolean expired;
    private Service proxiedBy;
    private final Map<String, Service> services = new HashMap<String, Service>();

    public MockTicketGrantingTicket(String principal) {
        this.id = ID_GENERATOR.getNewTicketId("TGT");
        BasicCredentialMetaData metaData = new BasicCredentialMetaData((Credential)TestUtils.getCredentialsWithSameUsernameAndPassword());
        this.authentication = new DefaultAuthenticationBuilder(new DefaultPrincipalFactory().createPrincipal(principal)).addCredential((CredentialMetaData)metaData).addSuccess(SimpleTestUsernamePasswordAuthenticationHandler.class.getName(), (HandlerResult)new DefaultHandlerResult((AuthenticationHandler)new SimpleTestUsernamePasswordAuthenticationHandler(), (CredentialMetaData)metaData)).build();
        this.created = new Date();
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public ServiceTicket grantServiceTicket(Service service) {
        return this.grantServiceTicket(ID_GENERATOR.getNewTicketId("ST"), service, null, true);
    }

    public ServiceTicket grantServiceTicket(String id, Service service, ExpirationPolicy expirationPolicy, boolean credentialsProvided) {
        ++this.usageCount;
        return new MockServiceTicket(id, service, this);
    }

    public Service getProxiedBy() {
        return this.proxiedBy;
    }

    public boolean isRoot() {
        return true;
    }

    public TicketGrantingTicket getRoot() {
        return this;
    }

    public List<Authentication> getSupplementalAuthentications() {
        return Collections.emptyList();
    }

    public List<Authentication> getChainedAuthentications() {
        return Collections.emptyList();
    }

    public String getId() {
        return this.id;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public TicketGrantingTicket getGrantingTicket() {
        return this;
    }

    public long getCreationTime() {
        return this.created.getTime();
    }

    public int getCountOfUses() {
        return this.usageCount;
    }

    public Map<String, Service> getServices() {
        return this.services;
    }

    public void removeAllServices() {
    }

    public void markTicketExpired() {
        this.expired = true;
    }
}

