/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.mock.MockService;
import org.jasig.cas.monitor.SessionMonitor;
import org.jasig.cas.monitor.SessionStatus;
import org.jasig.cas.monitor.StatusCode;
import org.jasig.cas.monitor.TicketRegistryState;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.DefaultTicketRegistry;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.support.HardTimeoutExpirationPolicy;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionMonitorTests {
    private static final ExpirationPolicy TEST_EXP_POLICY = new HardTimeoutExpirationPolicy(10000L);
    private static final UniqueTicketIdGenerator GENERATOR = new DefaultUniqueTicketIdGenerator();
    private DefaultTicketRegistry defaultRegistry;
    private SessionMonitor monitor;

    @Before
    public void setUp() {
        this.defaultRegistry = new DefaultTicketRegistry();
        this.monitor = new SessionMonitor();
        this.monitor.setTicketRegistry((TicketRegistryState)this.defaultRegistry);
    }

    @Test
    public void verifyObserveOk() throws Exception {
        this.addTicketsToRegistry((TicketRegistry)this.defaultRegistry, 5, 10);
        SessionStatus status = this.monitor.observe();
        Assert.assertEquals((long)5L, (long)status.getSessionCount());
        Assert.assertEquals((long)10L, (long)status.getServiceTicketCount());
        Assert.assertEquals((Object)StatusCode.OK, (Object)status.getCode());
    }

    @Test
    public void verifyObserveWarnSessionsExceeded() throws Exception {
        this.addTicketsToRegistry((TicketRegistry)this.defaultRegistry, 10, 1);
        this.monitor.setSessionCountWarnThreshold(5);
        SessionStatus status = this.monitor.observe();
        Assert.assertEquals((Object)StatusCode.WARN, (Object)status.getCode());
        Assert.assertTrue((boolean)status.getDescription().contains("Session count"));
    }

    @Test
    public void verifyObserveWarnServiceTicketsExceeded() throws Exception {
        this.addTicketsToRegistry((TicketRegistry)this.defaultRegistry, 1, 10);
        this.monitor.setServiceTicketCountWarnThreshold(5);
        SessionStatus status = this.monitor.observe();
        Assert.assertEquals((Object)StatusCode.WARN, (Object)status.getCode());
        Assert.assertTrue((boolean)status.getDescription().contains("Service ticket count"));
    }

    private void addTicketsToRegistry(TicketRegistry registry, int tgtCount, int stCount) {
        int i;
        TicketGrantingTicketImpl ticket = null;
        for (i = 0; i < tgtCount; ++i) {
            ticket = new TicketGrantingTicketImpl(GENERATOR.getNewTicketId("TGT"), TestUtils.getAuthentication(), TEST_EXP_POLICY);
            registry.addTicket((Ticket)ticket);
        }
        if (ticket != null) {
            for (i = 0; i < stCount; ++i) {
                registry.addTicket((Ticket)ticket.grantServiceTicket(GENERATOR.getNewTicketId("ST"), (Service)new MockService("junit"), TEST_EXP_POLICY, false));
            }
        }
    }
}

