/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.remoting.server;

import org.jasig.cas.AbstractCentralAuthenticationServiceTest;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.remoting.server.RemoteCentralAuthenticationService;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@Deprecated
public class RemoteCentralAuthenticationServiceTests
extends AbstractCentralAuthenticationServiceTest {
    private RemoteCentralAuthenticationService remoteCentralAuthenticationService;

    @Before
    public void onSetUp() throws Exception {
        this.remoteCentralAuthenticationService = new RemoteCentralAuthenticationService();
        this.remoteCentralAuthenticationService.setCentralAuthenticationService(this.getCentralAuthenticationService());
    }

    @Test
    public void verifyValidCredentials() throws Exception {
        this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
    }

    @Test
    public void verifyInvalidCredentials() throws Exception {
        try {
            this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithDifferentUsernameAndPassword(null, null)});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    @Test
    public void verifyDontUseValidatorsToCheckValidCredentials() throws Exception {
        try {
            this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithDifferentUsernameAndPassword()});
            Assert.fail((String)"AuthenticationException expected.");
        }
        catch (AuthenticationException e) {
            return;
        }
    }

    @Test
    public void verifyDestroyTicketGrantingTicket() {
        this.remoteCentralAuthenticationService.destroyTicketGrantingTicket("test");
    }

    @Test
    public void verifyGrantServiceTicketWithValidTicketGrantingTicket() throws Exception {
        TicketGrantingTicket ticketId = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.remoteCentralAuthenticationService.grantServiceTicket(ticketId.getId(), TestUtils.getService());
    }

    @Test
    public void verifyGrantServiceTicketWithValidCredentials() throws Exception {
        TicketGrantingTicket ticketGrantingTicketId = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicketId.getId(), TestUtils.getService(), new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
    }

    @Test
    public void verifyGrantServiceTicketWithNullCredentials() throws Exception {
        TicketGrantingTicket ticketGrantingTicketId = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicketId.getId(), TestUtils.getService(), (Credential[])null);
    }

    @Test
    public void verifyGrantServiceTicketWithEmptyCredentials() throws Exception {
        TicketGrantingTicket ticketGrantingTicketId = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        try {
            this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicketId.getId(), TestUtils.getService(), new Credential[]{TestUtils.getCredentialsWithDifferentUsernameAndPassword("", "")});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    @Test
    public void verifyValidateServiceTicketWithValidService() throws Exception {
        TicketGrantingTicket ticketGrantingTicket = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicket = this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicket.getId(), TestUtils.getService());
        this.remoteCentralAuthenticationService.validateServiceTicket(serviceTicket.getId(), TestUtils.getService());
    }

    @Test
    public void verifyDelegateTicketGrantingTicketWithValidCredentials() throws Exception {
        TicketGrantingTicket ticketGrantingTicket = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicket = this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicket.getId(), TestUtils.getService());
        this.remoteCentralAuthenticationService.delegateTicketGrantingTicket(serviceTicket.getId(), new Credential[]{TestUtils.getHttpBasedServiceCredentials()});
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyDelegateTicketGrantingTicketWithInvalidCredentials() throws Exception {
        TicketGrantingTicket ticketGrantingTicket = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicket = this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicket.getId(), TestUtils.getService());
        this.remoteCentralAuthenticationService.delegateTicketGrantingTicket(serviceTicket.getId(), new Credential[]{TestUtils.getCredentialsWithDifferentUsernameAndPassword("", "")});
        Assert.fail((String)"IllegalArgumentException expected.");
    }
}

