/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.PrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.jasig.cas.services.AnonymousRegisteredServiceUsernameAttributeProvider;
import org.jasig.cas.services.AttributeFilter;
import org.jasig.cas.services.AttributeReleasePolicy;
import org.jasig.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.jasig.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.jasig.cas.services.JsonServiceRegistryDao;
import org.jasig.cas.services.PrincipalAttributeRegisteredServiceUsernameProvider;
import org.jasig.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegexRegisteredService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceAccessStrategy;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.RegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegisteredServicePublicKey;
import org.jasig.cas.services.RegisteredServicePublicKeyImpl;
import org.jasig.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.jasig.cas.services.ReturnAllAttributeReleasePolicy;
import org.jasig.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.jasig.cas.services.ReturnMappedAttributeReleasePolicy;
import org.jasig.cas.services.ServiceRegistryDao;
import org.jasig.cas.services.support.RegisteredServiceRegexAttributeFilter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;

public class JsonServiceRegistryDaoTests {
    private static final ClassPathResource RESOURCE = new ClassPathResource("services");
    private final ServiceRegistryDao dao = new JsonServiceRegistryDao(RESOURCE.getFile());

    @BeforeClass
    public static void prepTests() throws Exception {
        FileUtils.cleanDirectory((File)RESOURCE.getFile());
    }

    @Test
    public void checkSaveMethodWithNonExistentServiceAndNoAttributes() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("testSaveMethodWithNonExistentServiceAndNoAttributes");
        r.setServiceId("testId");
        r.setTheme("theme");
        r.setDescription("description");
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assert.assertEquals((Object)r, (Object)r2);
        Assert.assertEquals((Object)r2, (Object)r3);
    }

    @Test
    public void execSaveMethodWithDefaultUsernameAttribute() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("testSaveMethodWithDefaultUsernameAttribute");
        r.setServiceId("testId");
        r.setTheme("theme");
        r.setDescription("description");
        r.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        Assert.assertEquals((Object)r2, (Object)r);
    }

    @Test
    public void ensureSaveMethodWithDefaultPrincipalAttribute() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("testSaveMethodWithDefaultPrincipalAttribute");
        r.setServiceId("testId");
        r.setTheme("theme");
        r.setDescription("description");
        r.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PrincipalAttributeRegisteredServiceUsernameProvider("cn"));
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        Assert.assertEquals((Object)r2, (Object)r);
    }

    @Test
    public void verifySaveMethodWithDefaultAnonymousAttribute() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("testSaveMethodWithDefaultAnonymousAttribute");
        r.setServiceId("testId");
        r.setTheme("theme");
        r.setDescription("description");
        r.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new AnonymousRegisteredServiceUsernameAttributeProvider((PersistentIdGenerator)new ShibbolethCompatiblePersistentIdGenerator("helloworld")));
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        AnonymousRegisteredServiceUsernameAttributeProvider anon = (AnonymousRegisteredServiceUsernameAttributeProvider)r2.getUsernameAttributeProvider();
        ShibbolethCompatiblePersistentIdGenerator ss = (ShibbolethCompatiblePersistentIdGenerator)anon.getPersistentIdGenerator();
        Assert.assertEquals((Object)new String(ss.getSalt()), (Object)"helloworld");
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assert.assertEquals((Object)r2, (Object)r3);
    }

    @Test
    public void verifySaveAttributeReleasePolicy() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("testSaveAttributeReleasePolicy");
        r.setServiceId("testId");
        r.setTheme("theme");
        r.setDescription("description");
        r.setAttributeReleasePolicy((AttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assert.assertEquals((Object)r, (Object)r2);
        Assert.assertEquals((Object)r2, (Object)r3);
        Assert.assertNotNull((Object)r3.getAttributeReleasePolicy());
        Assert.assertEquals((Object)r2.getAttributeReleasePolicy(), (Object)r3.getAttributeReleasePolicy());
    }

    @Test
    public void verifySaveMethodWithExistingServiceNoAttribute() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("testSaveMethodWithExistingServiceNoAttribute");
        r.setServiceId("testId");
        r.setTheme("theme");
        r.setDescription("description");
        this.dao.save((RegisteredService)r);
        r.setTheme("mytheme");
        this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r.getId());
        Assert.assertEquals((Object)r, (Object)r3);
    }

    @Test
    public void verifySaveAttributeReleasePolicyMappingRules() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("testSaveAttributeReleasePolicyMappingRules");
        r.setServiceId("testId");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("attr1", "newattr1");
        map.put("attr2", "newattr2");
        map.put("attr2", "newattr3");
        ReturnMappedAttributeReleasePolicy policy = new ReturnMappedAttributeReleasePolicy();
        policy.setAllowedAttributes(map);
        r.setAttributeReleasePolicy((AttributeReleasePolicy)policy);
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assert.assertEquals((Object)r, (Object)r2);
        Assert.assertEquals((Object)r2, (Object)r3);
        Assert.assertNotNull((Object)r3.getAttributeReleasePolicy());
        Assert.assertEquals((Object)r2.getAttributeReleasePolicy(), (Object)r3.getAttributeReleasePolicy());
    }

    @Test
    public void verifySaveAttributeReleasePolicyAllowedAttrRules() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("testSaveAttributeReleasePolicyAllowedAttrRules");
        r.setServiceId("testId");
        ReturnAllowedAttributeReleasePolicy policy = new ReturnAllowedAttributeReleasePolicy();
        policy.setAllowedAttributes(Arrays.asList("1", "2", "3"));
        r.setAttributeReleasePolicy((AttributeReleasePolicy)policy);
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assert.assertEquals((Object)r, (Object)r2);
        Assert.assertEquals((Object)r2, (Object)r3);
        Assert.assertNotNull((Object)r3.getAttributeReleasePolicy());
        Assert.assertEquals((Object)r2.getAttributeReleasePolicy(), (Object)r3.getAttributeReleasePolicy());
    }

    @Test
    public void verifySaveAttributeReleasePolicyAllowedAttrRulesAndFilter() {
        RegexRegisteredService r = new RegexRegisteredService();
        r.setName("testSaveAttributeReleasePolicyAllowedAttrRulesAndFilter");
        r.setServiceId("testId");
        r.setTheme("testtheme");
        r.setEvaluationOrder(1000);
        r.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(true, false));
        r.setProxyPolicy((RegisteredServiceProxyPolicy)new RegexMatchingRegisteredServiceProxyPolicy("https://.+"));
        r.setRequiredHandlers(new HashSet<String>(Arrays.asList("h1", "h2")));
        ReturnAllowedAttributeReleasePolicy policy = new ReturnAllowedAttributeReleasePolicy();
        policy.setAllowedAttributes(Arrays.asList("1", "2", "3"));
        r.setAttributeReleasePolicy((AttributeReleasePolicy)policy);
        r.getAttributeReleasePolicy().setAttributeFilter((AttributeFilter)new RegisteredServiceRegexAttributeFilter("\\w+"));
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assert.assertEquals((Object)r, (Object)r2);
        Assert.assertEquals((Object)r2, (Object)r3);
        Assert.assertNotNull((Object)r3.getAttributeReleasePolicy());
        Assert.assertEquals((Object)r2.getAttributeReleasePolicy(), (Object)r3.getAttributeReleasePolicy());
    }

    @Test
    public void verifyServiceType() {
        RegexRegisteredService r = new RegexRegisteredService();
        r.setServiceId("^https://.+");
        r.setName("testServiceType");
        r.setTheme("testtheme");
        r.setEvaluationOrder(1000);
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        Assert.assertTrue((boolean)(r2 instanceof RegexRegisteredService));
    }

    @Test(expected=RuntimeException.class)
    public void verifyServiceWithInvalidFileName() {
        RegexRegisteredService r = new RegexRegisteredService();
        r.setServiceId("^https://.+");
        r.setName("hell/o@world:*");
        r.setEvaluationOrder(1000);
        RegisteredService r2 = this.dao.save((RegisteredService)r);
    }

    @Test
    public void checkLoadingOfJsonServiceFiles() throws Exception {
        JsonServiceRegistryDaoTests.prepTests();
        this.verifySaveAttributeReleasePolicyAllowedAttrRulesWithCaching();
        this.verifySaveAttributeReleasePolicyAllowedAttrRulesAndFilter();
        Assert.assertEquals((long)this.dao.load().size(), (long)2L);
    }

    @Test
    public void verifySaveAttributeReleasePolicyAllowedAttrRulesWithCaching() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("testSaveAttributeReleasePolicyAllowedAttrRulesWithCaching");
        r.setServiceId("testId");
        ReturnAllowedAttributeReleasePolicy policy = new ReturnAllowedAttributeReleasePolicy();
        policy.setAllowedAttributes(Arrays.asList("1", "2", "3"));
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
        attributes.put("values", Arrays.asList("v1", "v2", "v3"));
        CachingPrincipalAttributesRepository repository = new CachingPrincipalAttributesRepository(TimeUnit.MILLISECONDS, 100L);
        repository.setMergingStrategy(CachingPrincipalAttributesRepository.MergingStrategy.REPLACE);
        policy.setPrincipalAttributesRepository((PrincipalAttributesRepository)repository);
        r.setAttributeReleasePolicy((AttributeReleasePolicy)policy);
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assert.assertEquals((Object)r, (Object)r2);
        Assert.assertEquals((Object)r2, (Object)r3);
        Assert.assertNotNull((Object)r3.getAttributeReleasePolicy());
        Assert.assertEquals((Object)r2.getAttributeReleasePolicy(), (Object)r3.getAttributeReleasePolicy());
        this.dao.load();
    }

    @Test
    public void verifyServiceRemovals() throws Exception {
        ArrayList<RegisteredService> list = new ArrayList<RegisteredService>(5);
        for (int i = 1; i < 5; ++i) {
            RegexRegisteredService r = new RegexRegisteredService();
            r.setServiceId("^https://.+");
            r.setName("testServiceType");
            r.setTheme("testtheme");
            r.setEvaluationOrder(1000);
            r.setId((long)(i * 100));
            list.add(this.dao.save((RegisteredService)r));
        }
        for (RegisteredService r2 : list) {
            this.dao.delete(r2);
            Thread.sleep(1L);
            Assert.assertNull((Object)this.dao.findServiceById(r2.getId()));
        }
    }

    @Test
    public void checkForAuthorizationStrategy() {
        RegexRegisteredService r = new RegexRegisteredService();
        r.setServiceId("^https://.+");
        r.setName("checkForAuthorizationStrategy");
        r.setId(42L);
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy(false, false);
        HashMap<String, HashSet> attrs = new HashMap<String, HashSet>();
        attrs.put("cn", Sets.newHashSet((Object[])new String[]{"v1, v2, v3"}));
        attrs.put("memberOf", Sets.newHashSet(Arrays.asList("v4, v5, v6")));
        authz.setRequiredAttributes(attrs);
        r.setAccessStrategy((RegisteredServiceAccessStrategy)authz);
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assert.assertEquals((Object)r2, (Object)r3);
    }

    @Test
    public void serializePublicKeyForServiceAndVerify() throws Exception {
        RegisteredServicePublicKeyImpl publicKey = new RegisteredServicePublicKeyImpl("classpath:RSA1024Public.key", "RSA");
        RegexRegisteredService r = new RegexRegisteredService();
        r.setServiceId("^https://.+");
        r.setName("serializePublicKeyForServiceAndVerify");
        r.setId(4245L);
        r.setPublicKey((RegisteredServicePublicKey)publicKey);
        this.dao.save((RegisteredService)r);
        List list = this.dao.load();
        Assert.assertNotNull((Object)this.dao.findServiceById(r.getId()));
    }
}

