/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.HashMap;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.services.PrincipalAttributeRegisteredServiceUsernameProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PrincipalAttributeRegisteredServiceUsernameProviderTests {
    @Test
    public void verifyUsernameByPrincipalAttribute() {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("userid", "u1");
        attrs.put("cn", "TheName");
        Principal p = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)p.getId()).thenReturn((Object)"person");
        Mockito.when((Object)p.getAttributes()).thenReturn(attrs);
        String id = provider.resolveUsername(p, TestUtils.getService());
        Assert.assertEquals((Object)id, (Object)"TheName");
    }

    @Test
    public void verifyUsernameByPrincipalAttributeNotFound() {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("userid", "u1");
        Principal p = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)p.getId()).thenReturn((Object)"person");
        Mockito.when((Object)p.getAttributes()).thenReturn(attrs);
        String id = provider.resolveUsername(p, TestUtils.getService());
        Assert.assertEquals((Object)id, (Object)p.getId());
    }

    @Test
    public void verifyEquality() {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        PrincipalAttributeRegisteredServiceUsernameProvider provider2 = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        Assert.assertEquals((Object)provider, (Object)provider2);
    }
}

