/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Arrays;
import java.util.Collection;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.mock.MockService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RegisteredServiceImplTests {
    private final RegisteredServiceImpl service;
    private final String serviceToMatch;
    private final boolean expected;

    public RegisteredServiceImplTests(RegisteredServiceImpl service, String serviceToMatch, boolean expectedResult) {
        this.service = service;
        this.serviceToMatch = serviceToMatch;
        this.expected = expectedResult;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({RegisteredServiceImplTests.newService("https://host.vt.edu/**"), "https://host.vt.edu/a/b/c?a=1&b=2", true}, {RegisteredServiceImplTests.newService("http://**"), "http://host.subdomain.example.com/service", true}, {RegisteredServiceImplTests.newService("https:/example.com/**"), null, false});
    }

    @Test
    public void verifyMatches() throws Exception {
        MockService testService = this.serviceToMatch == null ? null : new MockService(this.serviceToMatch);
        Assert.assertEquals((Object)this.expected, (Object)this.service.matches((Service)testService));
    }

    private static RegisteredServiceImpl newService(String id) {
        RegisteredServiceImpl service = new RegisteredServiceImpl();
        service.setServiceId(id);
        return service;
    }
}

