/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.support;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;
import org.jasig.cas.services.AttributeFilter;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.support.RegisteredServiceRegexAttributeFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RegisteredServiceRegexAttributeFilterTests {
    private final AttributeFilter filter = new RegisteredServiceRegexAttributeFilter("^.{5,}$");
    private final Map<String, Object> givenAttributesMap = new HashMap<String, Object>();
    @Mock
    private RegisteredService registeredService;

    public RegisteredServiceRegexAttributeFilterTests() {
        this.givenAttributesMap.put("uid", "loggedInTestUid");
        this.givenAttributesMap.put("phone", "1290");
        this.givenAttributesMap.put("familyName", "Smith");
        this.givenAttributesMap.put("givenName", "John");
        this.givenAttributesMap.put("employeeId", "E1234");
        this.givenAttributesMap.put("memberOf", Arrays.asList("math", "science", "chemistry"));
        this.givenAttributesMap.put("arrayAttribute", new String[]{"math", "science", "chemistry"});
        this.givenAttributesMap.put("setAttribute", new HashSet<String>(Arrays.asList("math", "science", "chemistry")));
        HashMap<String, String> mapAttributes = new HashMap<String, String>();
        mapAttributes.put("uid", "loggedInTestUid");
        mapAttributes.put("phone", "890");
        mapAttributes.put("familyName", "Smith");
        this.givenAttributesMap.put("mapAttribute", mapAttributes);
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.registeredService.getName()).thenReturn((Object)"sample test service");
        Mockito.when((Object)this.registeredService.getServiceId()).thenReturn((Object)"https://www.jasig.org");
    }

    @Test
    public void verifyPatternFilter() {
        Map attrs = this.filter.filter(this.givenAttributesMap);
        Assert.assertEquals((long)attrs.size(), (long)7L);
        Assert.assertFalse((boolean)attrs.containsKey("phone"));
        Assert.assertFalse((boolean)attrs.containsKey("givenName"));
        Assert.assertTrue((boolean)attrs.containsKey("uid"));
        Assert.assertTrue((boolean)attrs.containsKey("memberOf"));
        Assert.assertTrue((boolean)attrs.containsKey("mapAttribute"));
        Map mapAttributes = (Map)attrs.get("mapAttribute");
        Assert.assertTrue((boolean)mapAttributes.containsKey("uid"));
        Assert.assertTrue((boolean)mapAttributes.containsKey("familyName"));
        Assert.assertFalse((boolean)mapAttributes.containsKey("phone"));
        List obj = (List)attrs.get("memberOf");
        Assert.assertEquals((long)2L, (long)obj.size());
    }

    @Test
    public void verifySerialization() {
        byte[] data = SerializationUtils.serialize((Serializable)this.filter);
        AttributeFilter secondFilter = (AttributeFilter)SerializationUtils.deserialize((byte[])data);
        Assert.assertEquals((Object)secondFilter, (Object)this.filter);
    }
}

