/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.util.Collection;
import java.util.Collections;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.CentralAuthenticationServiceImpl;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.AbstractRegistryCleanerTests;
import org.jasig.cas.ticket.registry.DefaultTicketRegistry;
import org.jasig.cas.ticket.registry.RegistryCleaner;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.registry.support.DefaultTicketRegistryCleaner;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.mockito.Mockito;

public class DefaultTicketRegistryCleanerTests
extends AbstractRegistryCleanerTests {
    private CentralAuthenticationService centralAuthenticationService;

    @Override
    public RegistryCleaner getNewRegistryCleaner(TicketRegistry ticketRegistry) {
        this.centralAuthenticationService = new CentralAuthenticationServiceImpl(this.ticketRegistry, (AuthenticationManager)Mockito.mock(AuthenticationManager.class), (UniqueTicketIdGenerator)Mockito.mock(UniqueTicketIdGenerator.class), Collections.EMPTY_MAP, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), (ExpirationPolicy)new NeverExpiresExpirationPolicy(), (ServicesManager)Mockito.mock(ServicesManager.class), (LogoutManager)Mockito.mock(LogoutManager.class));
        return new DefaultTicketRegistryCleaner(this.centralAuthenticationService, this.ticketRegistry);
    }

    @Override
    public TicketRegistry getNewTicketRegistry() {
        return new DefaultTicketRegistry();
    }

    @Override
    protected void afterCleaning(Collection<Ticket> removedCol) {
        for (Ticket ticket : removedCol) {
            this.ticketRegistry.deleteTicket(ticket.getId());
        }
    }
}

