/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import java.util.Collections;
import javax.validation.constraints.NotNull;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.support.MultiTimeUseOrTimeoutExpirationPolicy;
import org.jasig.cas.ticket.support.RememberMeDelegatingExpirationPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class RememberMeDelegatingExpirationPolicyTests {
    @NotNull
    protected PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    private RememberMeDelegatingExpirationPolicy p;

    @Before
    public void setUp() throws Exception {
        this.p = new RememberMeDelegatingExpirationPolicy();
        this.p.setRememberMeExpirationPolicy((ExpirationPolicy)new MultiTimeUseOrTimeoutExpirationPolicy(1, 20000L));
        this.p.setSessionExpirationPolicy((ExpirationPolicy)new MultiTimeUseOrTimeoutExpirationPolicy(5, 20000L));
    }

    @Test
    public void verifyTicketExpirationWithRememberMe() {
        Authentication authentication = TestUtils.getAuthentication(this.principalFactory.createPrincipal("test"), Collections.singletonMap("org.jasig.cas.authentication.principal.REMEMBER_ME", true));
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("111", authentication, (ExpirationPolicy)this.p);
        Assert.assertFalse((boolean)t.isExpired());
        t.grantServiceTicket("55", TestUtils.getService(), (ExpirationPolicy)this.p, false);
        Assert.assertTrue((boolean)t.isExpired());
    }

    @Test
    public void verifyTicketExpirationWithoutRememberMe() {
        Authentication authentication = TestUtils.getAuthentication();
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("111", authentication, (ExpirationPolicy)this.p);
        Assert.assertFalse((boolean)t.isExpired());
        t.grantServiceTicket("55", TestUtils.getService(), (ExpirationPolicy)this.p, false);
        Assert.assertFalse((boolean)t.isExpired());
    }
}

