/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.logout;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SingleLogoutService;
import org.jasig.cas.logout.DefaultLogoutRequest;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.logout.LogoutManagerImpl$AjcClosure1;
import org.jasig.cas.logout.LogoutManagerImpl$AjcClosure3;
import org.jasig.cas.logout.LogoutMessageCreator;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.logout.LogoutRequestStatus;
import org.jasig.cas.services.LogoutType;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.CompressionUtils;
import org.jasig.cas.util.http.HttpClient;
import org.jasig.cas.util.http.HttpMessage;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogoutManagerImpl
implements LogoutManager {
    private static final Logger LOGGER;
    private static final String LOGOUT_PARAMETER_NAME = "logoutRequest";
    private static final Charset ASCII;
    @NotNull
    private final ServicesManager servicesManager;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final LogoutMessageCreator logoutMessageBuilder;
    private boolean singleLogoutCallbacksDisabled;
    private boolean asynchronous = true;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public LogoutManagerImpl(ServicesManager servicesManager, HttpClient httpClient, LogoutMessageCreator logoutMessageBuilder) {
        this.servicesManager = servicesManager;
        this.httpClient = httpClient;
        this.logoutMessageBuilder = logoutMessageBuilder;
    }

    public void setAsynchronous(boolean asyncCallbacks) {
        this.asynchronous = asyncCallbacks;
    }

    @Deprecated
    public void setIssueAsynchronousCallbacks(boolean asyncCallbacks) {
        this.asynchronous = asyncCallbacks;
        LOGGER.warn("setIssueAsynchronousCallbacks() is deprecated. Use setAsynchronous() instead.");
    }

    public List<LogoutRequest> performLogout(TicketGrantingTicket ticket) {
        TicketGrantingTicket ticketGrantingTicket = ticket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ticketGrantingTicket);
        Object[] objectArray = new Object[]{this, ticketGrantingTicket, joinPoint};
        return (List)TraceLogAspect.aspectOf().traceMethod(new LogoutManagerImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private boolean serviceSupportsSingleLogout(RegisteredService registeredService) {
        return registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed() && registeredService.getLogoutType() != LogoutType.NONE;
    }

    private LogoutRequest handleLogoutForSloService(SingleLogoutService singleLogoutService, String ticketId) {
        RegisteredService registeredService;
        if (!singleLogoutService.isLoggedOutAlready() && this.serviceSupportsSingleLogout(registeredService = this.servicesManager.findServiceBy((Service)singleLogoutService))) {
            URL logoutUrl = this.determineLogoutUrl(registeredService, singleLogoutService);
            DefaultLogoutRequest logoutRequest = new DefaultLogoutRequest(ticketId, singleLogoutService, logoutUrl);
            LogoutType type = registeredService.getLogoutType() == null ? LogoutType.BACK_CHANNEL : registeredService.getLogoutType();
            switch (type) {
                case BACK_CHANNEL: {
                    if (this.performBackChannelLogout(logoutRequest)) {
                        logoutRequest.setStatus(LogoutRequestStatus.SUCCESS);
                        break;
                    }
                    logoutRequest.setStatus(LogoutRequestStatus.FAILURE);
                    LOGGER.warn("Logout message not sent to [{}]; Continuing processing...", (Object)singleLogoutService.getId());
                    break;
                }
                default: {
                    logoutRequest.setStatus(LogoutRequestStatus.NOT_ATTEMPTED);
                }
            }
            return logoutRequest;
        }
        return null;
    }

    private URL determineLogoutUrl(RegisteredService registeredService, SingleLogoutService singleLogoutService) {
        try {
            URL logoutUrl = new URL(singleLogoutService.getOriginalUrl());
            URL serviceLogoutUrl = registeredService.getLogoutUrl();
            if (serviceLogoutUrl != null) {
                LOGGER.debug("Logout request will be sent to [{}] for service [{}]", (Object)serviceLogoutUrl, (Object)singleLogoutService);
                logoutUrl = serviceLogoutUrl;
            }
            return logoutUrl;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean performBackChannelLogout(LogoutRequest request) {
        try {
            String logoutRequest = this.logoutMessageBuilder.create(request);
            SingleLogoutService logoutService = request.getService();
            logoutService.setLoggedOutAlready(true);
            LOGGER.debug("Sending logout request for: [{}]", (Object)logoutService.getId());
            LogoutHttpMessage msg = new LogoutHttpMessage(request.getLogoutUrl(), logoutRequest);
            LOGGER.debug("Prepared logout message to send is [{}]", (Object)msg);
            return this.httpClient.sendMessageToEndPoint(msg);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String createFrontChannelLogoutMessage(LogoutRequest logoutRequest) {
        LogoutRequest logoutRequest2 = logoutRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)logoutRequest2);
        Object[] objectArray = new Object[]{this, logoutRequest2, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new LogoutManagerImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setSingleLogoutCallbacksDisabled(boolean singleLogoutCallbacksDisabled) {
        this.singleLogoutCallbacksDisabled = singleLogoutCallbacksDisabled;
    }

    static {
        LogoutManagerImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(LogoutManagerImpl.class);
        ASCII = Charset.forName("ASCII");
    }

    static final /* synthetic */ List performLogout_aroundBody0(LogoutManagerImpl ajc$this, TicketGrantingTicket ticket, JoinPoint joinPoint) {
        Map services = ticket.getServices();
        ArrayList<LogoutRequest> logoutRequests = new ArrayList<LogoutRequest>();
        if (!ajc$this.singleLogoutCallbacksDisabled) {
            for (Map.Entry entry : services.entrySet()) {
                LogoutRequest logoutRequest;
                Service service = (Service)entry.getValue();
                if (!(service instanceof SingleLogoutService) || (logoutRequest = ajc$this.handleLogoutForSloService((SingleLogoutService)service, (String)entry.getKey())) == null) continue;
                LOGGER.debug("Captured logout request [{}]", (Object)logoutRequest);
                logoutRequests.add(logoutRequest);
            }
        }
        return logoutRequests;
    }

    static final /* synthetic */ String createFrontChannelLogoutMessage_aroundBody2(LogoutManagerImpl ajc$this, LogoutRequest logoutRequest, JoinPoint joinPoint) {
        String logoutMessage = ajc$this.logoutMessageBuilder.create(logoutRequest);
        LOGGER.trace("Attempting to deflate the logout message [{}]", (Object)logoutMessage);
        return CompressionUtils.deflate(logoutMessage);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LogoutManagerImpl.java", LogoutManagerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "performLogout", "org.jasig.cas.logout.LogoutManagerImpl", "org.jasig.cas.ticket.TicketGrantingTicket", "ticket", "", "java.util.List"), 121);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createFrontChannelLogoutMessage", "org.jasig.cas.logout.LogoutManagerImpl", "org.jasig.cas.logout.LogoutRequest", LOGOUT_PARAMETER_NAME, "", "java.lang.String"), 244);
    }

    private final class LogoutHttpMessage
    extends HttpMessage {
        public LogoutHttpMessage(URL url, String message) {
            super(url, message, LogoutManagerImpl.this.asynchronous);
            this.setContentType("application/x-www-form-urlencoded");
        }

        @Override
        protected String formatOutputMessageInternal(String message) {
            return "logoutRequest=" + super.formatOutputMessageInternal(message);
        }
    }
}

