/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.monitor.AbstractNamedMonitor;
import org.jasig.cas.monitor.AbstractPoolMonitor$AjcClosure1;
import org.jasig.cas.monitor.AbstractPoolMonitor$Validator$AjcClosure1;
import org.jasig.cas.monitor.PoolStatus;
import org.jasig.cas.monitor.StatusCode;
import org.jasig.inspektr.aspect.TraceLogAspect;

public abstract class AbstractPoolMonitor
extends AbstractNamedMonitor<PoolStatus> {
    public static final int DEFAULT_MAX_WAIT = 3000;
    private int maxWait = 3000;
    @NotNull
    private ExecutorService executor;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public void setExecutor(ExecutorService executorService) {
        this.executor = executorService;
    }

    public void setMaxWait(int time) {
        this.maxWait = time;
    }

    public PoolStatus observe() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (PoolStatus)((Object)TraceLogAspect.aspectOf().traceMethod(new AbstractPoolMonitor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    protected abstract StatusCode checkPool() throws Exception;

    protected abstract int getIdleCount();

    protected abstract int getActiveCount();

    static {
        AbstractPoolMonitor.ajc$preClinit();
    }

    static final /* synthetic */ PoolStatus observe_aroundBody0(AbstractPoolMonitor ajc$this, JoinPoint joinPoint) {
        StatusCode code;
        Future<StatusCode> result = ajc$this.executor.submit(new Validator(ajc$this));
        String description = null;
        try {
            code = result.get(ajc$this.maxWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            code = StatusCode.UNKNOWN;
            description = "Validator thread interrupted during pool validation.";
        }
        catch (TimeoutException e) {
            code = StatusCode.WARN;
            description = String.format("Pool validation timed out.  Max wait is %s ms.", ajc$this.maxWait);
        }
        catch (Exception e) {
            code = StatusCode.ERROR;
            description = e.getMessage();
        }
        return new PoolStatus(code, description, ajc$this.getActiveCount(), ajc$this.getIdleCount());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractPoolMonitor.java", AbstractPoolMonitor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "observe", "org.jasig.cas.monitor.AbstractPoolMonitor", "", "", "", "org.jasig.cas.monitor.PoolStatus"), 73);
    }

    private static class Validator
    implements Callable<StatusCode> {
        private final AbstractPoolMonitor monitor;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public Validator(AbstractPoolMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public StatusCode call() throws Exception {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            Object[] objectArray = new Object[]{this, joinPoint};
            return (StatusCode)TraceLogAspect.aspectOf().traceMethod(new AbstractPoolMonitor$Validator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }

        static {
            Validator.ajc$preClinit();
        }

        static final /* synthetic */ StatusCode call_aroundBody0(Validator ajc$this, JoinPoint joinPoint) {
            return ajc$this.monitor.checkPool();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("AbstractPoolMonitor.java", Validator.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "call", "org.jasig.cas.monitor.AbstractPoolMonitor$Validator", "", "", "java.lang.Exception", "org.jasig.cas.monitor.StatusCode"), 132);
        }
    }
}

